
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
headsets = m.addVar(name="headsets", integer=True)
packs_of_paper = m.addVar(name="packs_of_paper", integer=True)

# Objective function
m.setObjective(6 * headsets * packs_of_paper + 4 * headsets, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(15 * headsets + 17 * packs_of_paper >= 30, name="sustainability_score")
m.addConstr(13 * headsets + 11 * packs_of_paper >= 55, name="usefulness_rating")
m.addConstr(-2 * headsets + packs_of_paper >= 0, name="linear_constraint")
# Note: Direct implementation of quadratic constraint is not straightforward in Gurobi's Python interface
#       for non-convex problems or those requiring specific handling, consult Gurobi documentation.
m.addConstr((15 * headsets)**2 + (17 * packs_of_paper)**2 <= 68, name="quadratic_constraint")
m.addConstr(15 * headsets + 17 * packs_of_paper <= 68, name="sustainability_score_upper_bound")
m.addConstr(13 * headsets + 11 * packs_of_paper <= 85, name="usefulness_rating_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Headsets: {headsets.varValue}")
    print(f"Packs of paper: {packs_of_paper.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
