
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")

# Set objective function
m.setObjective(5*calcium + 8*magnesium + 7*vitamin_b7 + 6*vitamin_b2, gp.GRB.MAXIMIZE)

# Add constraints based on resource attributes
digestive_support = 25*calcium + 6*magnesium + 16*vitamin_b7 + 8*vitamin_b2
kidney_support = 26*calcium + 20*magnesium + 26*vitamin_b7 + 24*vitamin_b2
immune_support = 3*calcium + 22*magnesium + 19*vitamin_b7 + 18*vitamin_b2

m.addConstr(digestive_support <= 162)
m.addConstr(kidney_support <= 551)
m.addConstr(immune_support <= 557)

# Add additional constraints
m.addConstr(25*calcium + 16*vitamin_b7 >= 22)
m.addConstr(25*calcium + 6*magnesium >= 18)
m.addConstr(6*magnesium + 16*vitamin_b7 >= 14)
m.addConstr(26*calcium + 20*magnesium + 26*vitamin_b7 >= 107)
m.addConstr(3*calcium + 22*magnesium >= 80)
m.addConstr(22*magnesium + 19*vitamin_b7 + 18*vitamin_b2 >= 98)
m.addConstr(3*calcium + 22*magnesium + 18*vitamin_b2 >= 98)
m.addConstr(22*magnesium + 19*vitamin_b7 + 18*vitamin_b2 >= 104)
m.addConstr(3*calcium + 22*magnesium + 18*vitamin_b2 >= 104)
m.addConstr(6*magnesium + 8*vitamin_b2 <= 102)
m.addConstr(25*calcium + 8*vitamin_b2 <= 149)
m.addConstr(25*calcium + 16*vitamin_b7 + 8*vitamin_b2 <= 43)
m.addConstr(25*calcium + 6*magnesium + 16*vitamin_b7 <= 84)
m.addConstr(25*calcium + 6*magnesium + 8*vitamin_b2 <= 96)
m.addConstr(25*calcium + 6*magnesium + 16*vitamin_b7 + 8*vitamin_b2 <= 96)
m.addConstr(20*magnesium + 24*vitamin_b2 <= 276)
m.addConstr(20*magnesium + 26*vitamin_b7 <= 241)
m.addConstr(20*magnesium + 26*vitamin_b7 + 24*vitamin_b2 <= 155)
m.addConstr(26*calcium + 20*magnesium + 24*vitamin_b2 <= 548)
m.addConstr(26*calcium + 20*magnesium + 26*vitamin_b7 <= 329)
m.addConstr(26*calcium + 26*vitamin_b7 + 24*vitamin_b2 <= 455)
m.addConstr(26*calcium + 20*magnesium + 26*vitamin_b7 + 24*vitamin_b2 <= 455)
m.addConstr(3*calcium + 19*vitamin_b7 <= 495)
m.addConstr(3*calcium + 22*magnesium <= 279)
m.addConstr(22*magnesium + 19*vitamin_b7 + 18*vitamin_b2 <= 513)
m.addConstr(3*calcium + 19*vitamin_b7 + 18*vitamin_b2 <= 342)
m.addConstr(3*calcium + 22*magnesium + 19*vitamin_b7 <= 201)
m.addConstr(3*calcium + 22*magnesium + 19*vitamin_b7 + 18*vitamin_b2 <= 201)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

