
from gurobipy import *

# Create a model
m = Model("Vitamin_Optimization")

# Define variables
vitamin_K = m.addVar(name="milligrams_of_vitamin_K", lb=0, ub=GRB.INFINITY)
vitamin_B5 = m.addVar(name="milligrams_of_vitamin_B5", lb=0, ub=GRB.INFINITY)
vitamin_A = m.addVar(name="milligrams_of_vitamin_A", lb=0, ub=GRB.INFINITY)

# Objective function
m.setObjective(3 * vitamin_K * vitamin_B5 + 3 * vitamin_B5**2 + 2 * vitamin_B5 + 3 * vitamin_A, GRB.MAXIMIZE)

# Constraints
# Cognitive performance index constraints
m.addConstr(vitamin_K * 5 + vitamin_B5 * 4 + vitamin_A * 14 >= 32, name="cognitive_combined_min")
m.addConstr(vitamin_K * 5 + vitamin_B5 * 4 + vitamin_A * 14 <= 70, name="cognitive_combined_max")
m.addConstr(vitamin_B5 * 4 + vitamin_A * 14 >= 42, name="cognitive_B5_A_min")
m.addConstr(vitamin_K * 5 + vitamin_A * 14 >= 38, name="cognitive_K_A_min")

# Kidney support index constraints
m.addConstr(vitamin_K**2 * 17 + vitamin_A**2 * 5 >= 30, name="kidney_K_A_squared_min")
m.addConstr(vitamin_B5**2 * 10 + vitamin_A**2 * 5 <= 105, name="kidney_B5_A_squared_max")
m.addConstr(vitamin_K * 17 + vitamin_B5 * 10 + vitamin_A * 5 <= 121, name="kidney_combined_max")

# Cardiovascular support index constraints
m.addConstr(vitamin_K**2 * 14 + vitamin_B5**2 * 17 + vitamin_A**2 * 4 >= 27, name="cardiovascular_combined_min")
m.addConstr(vitamin_K * 14 + vitamin_B5 * 17 <= 68, name="cardiovascular_K_B5_max")
m.addConstr(vitamin_K * 14 + vitamin_A * 4 <= 72, name="cardiovascular_K_A_max")
m.addConstr(vitamin_K * 14 + vitamin_B5 * 17 + vitamin_A * 4 <= 72, name="cardiovascular_combined_max")

# Immune support index constraints
m.addConstr(vitamin_K * 10 + vitamin_B5 * 16 + vitamin_A * 6 >= 59, name="immune_combined_min")
m.addConstr(vitamin_K * 10 + vitamin_B5 * 16 + vitamin_A * 6 <= 102, name="immune_combined_max")
m.addConstr(vitamin_K * 10 + vitamin_A * 6 <= 85, name="immune_K_A_max")
m.addConstr(vitamin_K * 10 + vitamin_B5 * 16 <= 102, name="immune_K_B5_max")

# Optimize
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin K: {vitamin_K.x}")
    print(f"Milligrams of Vitamin B5: {vitamin_B5.x}")
    print(f"Milligrams of Vitamin A: {vitamin_A.x}")
else:
    print("No optimal solution found")
