
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_K")  
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B5")  
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_A")  

# Objective function
m.setObjective(3 * x0 * x1 + 3 * x1**2 + 2 * x1 + 3 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 == 5)
m.addConstr(x1 == 4)
m.addConstr(x2 == 14)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Vitamin K: ", x0.varValue)
    print("Vitamin B5: ", x1.varValue)
    print("Vitamin A: ", x2.varValue)
else:
    print("The model is infeasible")
