
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
    laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")

    # Set objective function
    model.setObjective(4.44 * jean + 5.12 * peggy + 2.1 * bobby + 7.6 * laura, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9 * peggy + 16 * laura >= 56, "c0")
    model.addConstr(15 * bobby + 16 * laura >= 59, "c1")
    model.addConstr(5 * bobby + 2 * laura >= 13, "c2")
    model.addConstr(13 * jean + 5 * bobby >= 34, "c3")
    model.addConstr(16 * peggy + 5 * bobby >= 26, "c4")
    model.addConstr(13 * jean + 16 * peggy + 5 * bobby >= 29, "c5")
    model.addConstr(13 * jean + 16 * peggy + 2 * laura >= 29, "c6")
    model.addConstr(16 * peggy + 5 * bobby + 2 * laura >= 29, "c7")
    model.addConstr(13 * jean + 16 * peggy + 5 * bobby >= 35, "c8")
    model.addConstr(13 * jean + 16 * peggy + 2 * laura >= 35, "c9")
    model.addConstr(16 * peggy + 5 * bobby + 2 * laura >= 35, "c10")
    model.addConstr(13 * jean + 16 * peggy + 5 * bobby >= 35, "c11")
    model.addConstr(13 * jean + 16 * peggy + 2 * laura >= 35, "c12")
    model.addConstr(16 * peggy + 5 * bobby + 2 * laura >= 35, "c13")
    model.addConstr(10 * jean + 8 * bobby + 10 * laura >= 42, "c14")
    model.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 42, "c15")
    model.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 42, "c16")
    model.addConstr(10 * jean + 8 * bobby + 10 * laura >= 34, "c17")
    model.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 34, "c18")
    model.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 34, "c19")
    model.addConstr(10 * jean + 8 * bobby + 10 * laura >= 28, "c20")
    model.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 28, "c21")
    model.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 28, "c22")
    model.addConstr(9 * jean + 9 * peggy <= 76, "c23")
    model.addConstr(9 * jean + 15 * bobby <= 192, "c24")
    model.addConstr(9 * peggy + 16 * laura <= 63, "c25")
    model.addConstr(9 * jean + 9 * peggy + 15 * bobby + 16 * laura <= 63, "c26")
    model.addConstr(16 * peggy + 5 * bobby <= 96, "c27")
    model.addConstr(13 * jean + 2 * laura <= 78, "c28")
    model.addConstr(16 * peggy + 2 * laura <= 142, "c29")
    model.addConstr(13 * jean + 16 * peggy + 5 * bobby + 2 * laura <= 142, "c30")
    model.addConstr(10 * jean + 5 * peggy <= 126, "c31")
    model.addConstr(5 * peggy + 10 * laura <= 114, "c32")
    model.addConstr(10 * jean + 8 * bobby <= 59, "c33")
    model.addConstr(10 * jean + 5 * peggy + 10 * laura <= 52, "c34")
    model.addConstr(10 * jean + 5 * peggy + 8 * bobby + 10 * laura <= 52, "c35")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
