
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
jean = m.addVar(name="jean", lb=0)
peggy = m.addVar(name="peggy", lb=0)
bobby = m.addVar(name="bobby", lb=0)
laura = m.addVar(name="laura", lb=0)

# Objective function
m.setObjective(4.44 * jean + 5.12 * peggy + 2.1 * bobby + 7.6 * laura, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(9 * jean <= 9)
m.addConstr(13 * jean <= 13)
m.addConstr(10 * jean <= 10)

m.addConstr(9 * peggy <= 9)
m.addConstr(16 * peggy <= 16)
m.addConstr(5 * peggy <= 5)

m.addConstr(15 * bobby <= 15)
m.addConstr(5 * bobby <= 5)
m.addConstr(8 * bobby <= 8)

m.addConstr(16 * laura <= 16)
m.addConstr(2 * laura <= 2)
m.addConstr(10 * laura <= 10)

m.addConstr(9 * peggy + 16 * laura >= 56)
m.addConstr(15 * bobby + 16 * laura >= 59)
m.addConstr(5 * bobby + 2 * laura >= 13)
m.addConstr(13 * jean + 5 * bobby >= 34)
m.addConstr(16 * peggy + 5 * bobby >= 26)
m.addConstr(13 * jean + 16 * peggy + 5 * bobby >= 29)
m.addConstr(13 * jean + 16 * peggy + 2 * laura >= 29)
m.addConstr(16 * peggy + 5 * bobby + 2 * laura >= 29)
m.addConstr(13 * jean + 16 * peggy + 5 * bobby >= 35)
m.addConstr(13 * jean + 16 * peggy + 2 * laura >= 35)
m.addConstr(16 * peggy + 5 * bobby + 2 * laura >= 35)

m.addConstr(10 * jean + 8 * bobby + 10 * laura >= 42)
m.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 42)
m.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 42)
m.addConstr(10 * jean + 8 * bobby + 10 * laura >= 34)
m.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 34)
m.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 34)
m.addConstr(10 * jean + 8 * bobby + 10 * laura >= 28)
m.addConstr(5 * peggy + 8 * bobby + 10 * laura >= 28)
m.addConstr(10 * jean + 5 * peggy + 8 * bobby >= 28)

m.addConstr(9 * jean + 9 * peggy <= 76)
m.addConstr(9 * jean + 15 * bobby <= 192)
m.addConstr(9 * peggy + 16 * laura <= 63)
m.addConstr(9 * jean + 9 * peggy + 15 * bobby + 16 * laura <= 63)
m.addConstr(16 * peggy + 5 * bobby <= 96)
m.addConstr(13 * jean + 2 * laura <= 78)
m.addConstr(16 * peggy + 2 * laura <= 142)
m.addConstr(13 * jean + 16 * peggy + 5 * bobby + 2 * laura <= 142)
m.addConstr(10 * jean + 5 * peggy <= 126)
m.addConstr(5 * peggy + 10 * laura <= 114)
m.addConstr(10 * jean + 8 * bobby <= 59)
m.addConstr(10 * jean + 5 * peggy + 10 * laura <= 52)
m.addConstr(10 * jean + 5 * peggy + 8 * bobby + 10 * laura <= 52)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Jean: ", jean.varValue)
    print("Peggy: ", peggy.varValue)
    print("Bobby: ", bobby.varValue)
    print("Laura: ", laura.varValue)
else:
    print("The model is infeasible")
