
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")
    security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")

    # Set objective function
    m.setObjective(9.05 * security_onions + 8.15 * pen_testers + 7.34 * deployed_decoys + 9.75 * security_engineers, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * security_onions + 11 * pen_testers + 9 * deployed_decoys + 6 * security_engineers <= 279, "power_consumption")
    m.addConstr(9 * security_onions + 1 * pen_testers + 3 * deployed_decoys + 10 * security_engineers <= 200, "computational_load")
    m.addConstr(11 * pen_testers + 6 * security_engineers >= 56, "pen_testers_security_engineers_power")
    m.addConstr(11 * pen_testers + 9 * deployed_decoys >= 57, "pen_testers_deployed_decoys_power")
    m.addConstr(-10 * security_onions + 10 * security_engineers >= 0, "security_onions_security_engineers_relation")
    m.addConstr(2 * security_onions + 6 * security_engineers <= 244, "security_onions_security_engineers_power")
    m.addConstr(11 * pen_testers + 6 * security_engineers <= 189, "pen_testers_security_engineers_power_max")
    m.addConstr(11 * pen_testers + 9 * deployed_decoys <= 144, "pen_testers_deployed_decoys_power_max")
    m.addConstr(2 * security_onions + 11 * pen_testers <= 185, "security_onions_pen_testers_power")
    m.addConstr(9 * deployed_decoys + 6 * security_engineers <= 141, "deployed_decoys_security_engineers_power")
    m.addConstr(2 * security_onions + 11 * pen_testers + 9 * deployed_decoys + 6 * security_engineers <= 141, "total_power_consumption")
    m.addConstr(3 * deployed_decoys + 10 * security_engineers <= 85, "deployed_decoys_security_engineers_load")
    m.addConstr(1 * pen_testers + 10 * security_engineers <= 56, "pen_testers_security_engineers_load")
    m.addConstr(9 * security_onions + 1 * pen_testers + 10 * security_engineers <= 70, "security_onions_pen_testers_security_engineers_load")
    m.addConstr(1 * pen_testers + 3 * deployed_decoys + 10 * security_engineers <= 101, "pen_testers_deployed_decoys_security_engineers_load")
    m.addConstr(9 * security_onions + 1 * pen_testers + 3 * deployed_decoys <= 114, "security_onions_pen_testers_deployed_decoys_load")
    m.addConstr(9 * security_onions + 3 * deployed_decoys + 10 * security_engineers <= 196, "security_onions_deployed_decoys_security_engineers_load")
    m.addConstr(9 * security_onions + 1 * pen_testers + 3 * deployed_decoys + 10 * security_engineers <= 196, "total_computational_load")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('security_onions:', security_onions.x)
        print('pen_testers:', pen_testers.x)
        print('deployed_decoys:', deployed_decoys.x)
        print('security_engineers:', security_engineers.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
