
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    security_onions = model.addVar(name="security_onions", vtype=gurobi.GRB.INTEGER)
    pen_testers = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    deployed_decoys = model.addVar(name="deployed_decoys", vtype=gurobi.GRB.INTEGER)
    security_engineers = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9.05 * security_onions + 8.15 * pen_testers + 7.34 * deployed_decoys + 9.75 * security_engineers, gurobi.GRB.MAXIMIZE)

    # Power consumption constraints
    model.addConstr(2 * security_onions + 11 * pen_testers + 9 * deployed_decoys + 6 * security_engineers <= 141, "total_power_consumption")
    model.addConstr(pen_testers + security_engineers >= 56, "pen_testers_security_engineers_power")
    model.addConstr(pen_testers + deployed_decoys >= 57, "pen_testers_deployed_decoys_power")
    model.addConstr(-10 * security_onions + 10 * security_engineers >= 0, "security_onions_security_engineers_power")
    model.addConstr(security_onions + security_engineers <= 244, "security_onions_security_engineers_total_power")
    model.addConstr(pen_testers + security_engineers <= 189, "pen_testers_security_engineers_total_power")
    model.addConstr(pen_testers + deployed_decoys <= 144, "pen_testers_deployed_decoys_total_power")
    model.addConstr(security_onions + pen_testers <= 185, "security_onions_pen_testers_total_power")
    model.addConstr(deployed_decoys + security_engineers <= 141, "deployed_decoys_security_engineers_total_power")

    # Computational load constraints
    model.addConstr(9 * security_onions + pen_testers + 3 * deployed_decoys + 10 * security_engineers <= 196, "total_computational_load")
    model.addConstr(3 * deployed_decoys + 10 * security_engineers <= 85, "deployed_decoys_security_engineers_computational_load")
    model.addConstr(pen_testers + 10 * security_engineers <= 56, "pen_testers_security_engineers_computational_load")
    model.addConstr(9 * security_onions + pen_testers + 10 * security_engineers <= 70, "security_onions_pen_testers_security_engineers_computational_load")
    model.addConstr(pen_testers + 3 * deployed_decoys + 10 * security_engineers <= 101, "pen_testers_deployed_decoys_security_engineers_computational_load")
    model.addConstr(9 * security_onions + pen_testers + 3 * deployed_decoys <= 114, "security_onions_pen_testers_deployed_decoys_computational_load")
    model.addConstr(9 * security_onions + 3 * deployed_decoys + 10 * security_engineers <= 196, "security_onions_deployed_decoys_security_engineers_computational_load")

    # Variable bounds
    model.addConstr(security_onions >= 0, "security_onions_lower_bound")
    model.addConstr(pen_testers >= 0, "pen_testers_lower_bound")
    model.addConstr(deployed_decoys >= 0, "deployed_decoys_lower_bound")
    model.addConstr(security_engineers >= 0, "security_engineers_lower_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Onions: {security_onions.varValue}")
        print(f"Pen Testers: {pen_testers.varValue}")
        print(f"Deployed Decoys: {deployed_decoys.varValue}")
        print(f"Security Engineers: {security_engineers.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
