
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fiber = m.addVar(lb=0, name="fiber")  # grams of fiber
vitamin_b5 = m.addVar(lb=0, name="vitamin_b5")  # milligrams of vitamin B5

# Set objective function
m.setObjective(1 * fiber + 2 * vitamin_b5, gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints (upper bounds are already incorporated in the problem data)
m.addConstr(4 * fiber + 4 * vitamin_b5 >= 1, "cognitive_performance_min") # Combined cognitive performance
m.addConstr(4 * fiber + 4 * vitamin_b5 <= 11, "cognitive_performance_max") # Combined cognitive performance
m.addConstr(3 * fiber + 4 * vitamin_b5 >= 6, "kidney_support_min") # Combined kidney support
m.addConstr(3 * fiber + 4 * vitamin_b5 <= 26, "kidney_support_max") # Combined kidney support
m.addConstr(1 * fiber + 3 * vitamin_b5 >= 6, "digestive_support_min") # Combined digestive support
m.addConstr(1 * fiber + 3 * vitamin_b5 <= 22, "digestive_support_max") # Combined digestive support


m.addConstr(-2 * fiber + 4 * vitamin_b5 >= 0, "additional_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Grams of fiber: {fiber.x}")
    print(f"Milligrams of vitamin B5: {vitamin_b5.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

