
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")

# Objective function: minimize 1*x0 + 2*x1
m.setObjective(1*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(4*x0 + 4*x1 >= 1, "cognitive_performance_min")
m.addConstr(4*x0 + 4*x1 <= 11, "cognitive_performance_max")
m.addConstr(3*x0 + 4*x1 >= 6, "kidney_support_min")
m.addConstr(3*x0 + 4*x1 <= 26, "kidney_support_max")
m.addConstr(1*x0 + 3*x1 >= 6, "digestive_support_min")
m.addConstr(1*x0 + 3*x1 <= 22, "digestive_support_max")
m.addConstr(-2*x0 + 4*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"grams_of_fiber: {x0.x}")
    print(f"milligrams_of_vitamin_B5: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
