
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    grams_of_fiber = model.addVar(lb=0, name="grams_of_fiber", vtype=gurobi.GRB.CONTINUOUS)
    milligrams_of_vitamin_B5 = model.addVar(lb=0, name="milligrams_of_vitamin_B5", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(grams_of_fiber + 2 * milligrams_of_vitamin_B5, gurobi.GRB.MINIMIZE)

    # Cognitive performance index constraint: 4 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 1
    model.addConstr(4 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 1, name="cognitive_performance_index_min")

    # Cognitive performance index upper bound: 4 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 <= 11
    model.addConstr(4 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 <= 11, name="cognitive_performance_index_max")

    # Kidney support index constraints: 3 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 6
    model.addConstr(3 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 6, name="kidney_support_index_min")

    # Kidney support index upper bound: 3 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 <= 33
    model.addConstr(3 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 <= 33, name="kidney_support_index_max")

    # Digestive support index constraints: 1 * grams_of_fiber + 3 * milligrams_of_vitamin_B5 >= 6
    model.addConstr(1 * grams_of_fiber + 3 * milligrams_of_vitamin_B5 >= 6, name="digestive_support_index_min")

    # Digestive support index upper bound: 1 * grams_of_fiber + 3 * milligrams_of_vitamin_B5 <= 23
    model.addConstr(1 * grams_of_fiber + 3 * milligrams_of_vitamin_B5 <= 23, name="digestive_support_index_max")

    # Interaction constraint: -2 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 0
    model.addConstr(-2 * grams_of_fiber + 4 * milligrams_of_vitamin_B5 >= 0, name="interaction_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {grams_of_fiber.varValue}")
        print(f"Milligrams of vitamin B5: {milligrams_of_vitamin_B5.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
