
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Work Hours")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
peggy_hours = model.addVar(vtype=GRB.INTEGER, name="peggy_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
john_hours = model.addVar(vtype=GRB.INTEGER, name="john_hours")

# Set objective function
model.setObjective(1 * dale_hours * peggy_hours + 1 * dale_hours * paul_hours + 3 * dale_hours * john_hours + 4 * peggy_hours * peggy_hours + 8 * peggy_hours * paul_hours + 6 * peggy_hours * john_hours + 7 * paul_hours * john_hours + 1 * john_hours * john_hours + 4 * dale_hours + 8 * peggy_hours + 2 * paul_hours + 2 * john_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * paul_hours + 4 * john_hours >= 25, "c1")
model.addConstr(5 * dale_hours * dale_hours + 11 * paul_hours * paul_hours >= 17, "c2")
model.addConstr(8 * peggy_hours + 4 * john_hours >= 25, "c3")
model.addConstr(5 * dale_hours + 4 * john_hours >= 10, "c4")
model.addConstr(5 * dale_hours + 8 * peggy_hours + 11 * paul_hours >= 24, "c5")
model.addConstr(5 * dale_hours + 8 * peggy_hours + 11 * paul_hours + 4 * john_hours >= 24, "c6")

model.addConstr(2 * peggy_hours + 9 * john_hours >= 31, "c7")
model.addConstr(7 * dale_hours + 9 * john_hours >= 16, "c8")
model.addConstr(7 * dale_hours + 2 * peggy_hours + 2 * paul_hours >= 31, "c9")
model.addConstr(7 * dale_hours + 2 * peggy_hours + 2 * paul_hours + 9 * john_hours >= 31, "c10")
model.addConstr(2 * peggy_hours + 2 * paul_hours <= 80, "c11")
model.addConstr(7 * dale_hours + 9 * john_hours <= 67, "c12")
model.addConstr(7 * dale_hours * dale_hours + 2 * paul_hours * paul_hours + 9 * john_hours * john_hours <= 55, "c13")
model.addConstr(7 * dale_hours + 2 * peggy_hours + 2 * paul_hours <= 53, "c14")
model.addConstr(2 * peggy_hours + 2 * paul_hours + 9 * john_hours <= 88, "c15")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Dale Hours:', dale_hours.x)
    print('Peggy Hours:', peggy_hours.x)
    print('Paul Hours:', paul_hours.x)
    print('John Hours:', john_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

