
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Peggy", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="hours_worked_by_John", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(1 * x0 * x1 + 1 * x0 * x2 + 3 * x0 * x3 + 4 * x1**2 + 8 * x1 * x2 + 6 * x1 * x3 + 7 * x2 * x3 + 1 * x3**2 + 4 * x0 + 8 * x1 + 2 * x2 + 2 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * x2 + 4 * x3 >= 25)
m.addConstr(25 * x0**2 + 121 * x2**2 >= 17)
m.addConstr(8 * x1 + 4 * x3 >= 25)
m.addConstr(5 * x0 + 4 * x3 >= 10)
m.addConstr(5 * x0 + 8 * x1 + 11 * x2 >= 24)
m.addConstr(5 * x0 + 8 * x1 + 11 * x2 + 4 * x3 >= 24)
m.addConstr(2 * x1 + 9 * x3 >= 31)
m.addConstr(7 * x0 + 9 * x3 >= 16)
m.addConstr(7 * x0 + 2 * x1 + 2 * x2 >= 31)
m.addConstr(7 * x0 + 2 * x1 + 2 * x2 + 9 * x3 >= 31)
m.addConstr(2 * x1 + 2 * x2 <= 80)
m.addConstr(7 * x0 + 9 * x3 <= 67)
m.addConstr(49 * x0**2 + 4 * x2**2 + 81 * x3**2 <= 55)
m.addConstr(7 * x0 + 2 * x1 + 2 * x2 <= 53)
m.addConstr(2 * x1 + 2 * x2 + 9 * x3 <= 88)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x0.varValue}")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by Paul: {x2.varValue}")
    print(f"Hours worked by John: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
