
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    scissors = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    smoke_detectors = model.addVar(name="smoke_detectors", vtype=gurobi.GRB.INTEGER)
    hole_punches = model.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)
    mechanical_pencils = model.addVar(name="mechanical_pencils", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.78 * scissors + 4.79 * smoke_detectors + 1.44 * hole_punches + 8.87 * mechanical_pencils, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(22 * scissors <= 294, name="sustainability_scissors")
    model.addConstr(3 * scissors + 26 * smoke_detectors + 11 * hole_punches + 6 * mechanical_pencils <= 373, name="storage_space_total")
    model.addConstr(26 * smoke_detectors + 11 * hole_punches >= 75, name="storage_smoke_hole_min")
    model.addConstr(26 * smoke_detectors + 6 * mechanical_pencils >= 77, name="storage_smoke_mechanical_min")
    model.addConstr(3 * scissors + 26 * smoke_detectors + 6 * mechanical_pencils >= 93, name="storage_scissors_smoke_mechanical_min")
    model.addConstr(21 * smoke_detectors + 28 * hole_punches <= 105, name="sustainability_smoke_hole")
    model.addConstr(28 * hole_punches + 9 * mechanical_pencils <= 122, name="sustainability_hole_mechanical")
    model.addConstr(22 * scissors + 9 * mechanical_pencils <= 144, name="sustainability_scissors_mechanical")
    model.addConstr(22 * scissors + 28 * hole_punches <= 140, name="sustainability_scissors_hole")
    model.addConstr(22 * scissors + 21 * smoke_detectors + 28 * hole_punches + 9 * mechanical_pencils <= 93, name="sustainability_total")
    model.addConstr(3 * scissors + 26 * smoke_detectors <= 327, name="storage_scissors_smoke")
    model.addConstr(3 * scissors + 6 * mechanical_pencils <= 157, name="storage_scissors_mechanical")
    model.addConstr(3 * scissors + 11 * hole_punches <= 251, name="storage_scissors_hole")
    model.addConstr(11 * hole_punches + 6 * mechanical_pencils <= 175, name="storage_hole_mechanical")
    model.addConstr(3 * scissors + 26 * smoke_detectors + 6 * mechanical_pencils <= 184, name="storage_scissors_smoke_mechanical")
    model.addConstr(3 * scissors + 26 * smoke_detectors + 11 * hole_punches + 6 * mechanical_pencils <= 184, name="storage_total_limited")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Scissors: ", scissors.varValue)
        print("Smoke Detectors: ", smoke_detectors.varValue)
        print("Hole Punches: ", hole_punches.varValue)
        print("Mechanical Pencils: ", mechanical_pencils.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
