
import gurobi as gp

# Create a new model
m = gp.Model("nutrition")

# Define variables
z = m.addVar(lb=0, name="zinc")  # milligrams of zinc
b = m.addVar(lb=0, name="vitamin_B6")  # milligrams of vitamin B6
c = m.addVar(lb=0, name="vitamin_C")  # milligrams of vitamin C
a = m.addVar(lb=0, name="calcium")  # milligrams of calcium
h = m.addVar(lb=0, name="carbohydrates")  # grams of carbohydrates
p = m.addVar(lb=0, name="protein")  # grams of protein
e = m.addVar(lb=0, name="iron")  # milligrams of iron

# Objective function
m.setObjective(9.89 * z + 1.51 * b + 2.87 * c + 4.27 * a + 6.7 * h + 7.82 * p + 8.78 * e, gp.GRB.MINIMIZE)

# Constraints
# Immune support index constraints
m.addConstr(5 * z + 6 * b + 3 * c + 6 * a + 6 * h + 5 * p + 5 * e <= 206)
m.addConstr(6 * h + 5 * p + 5 * e >= 11)
m.addConstr(6 * a + 6 * h >= 24)
m.addConstr(6 * b + 5 * e >= 23)
m.addConstr(6 * h + 5 * p >= 13)
m.addConstr(3 * c + 5 * p >= 9)
m.addConstr(5 * p + 5 * e >= 16)
m.addConstr(5 * z + 6 * h >= 28)
m.addConstr(6 * b + 5 * p >= 14)
m.addConstr(5 * z + 6 * a >= 13)
m.addConstr(3 * c + 6 * h >= 24)
m.addConstr(3 * c + 6 * a >= 15)
m.addConstr(6 * b + 6 * h >= 20)
m.addConstr(6 * a + 5 * e >= 18)
m.addConstr(5 * z + 3 * c >= 16)
m.addConstr(5 * z + 3 * c + 5 * p >= 23)
m.addConstr(6 * b + 5 * p + 5 * e >= 23)
m.addConstr(3 * c + 6 * a + 5 * p >= 23)
m.addConstr(5 * z + 6 * a + 5 * p >= 23)
m.addConstr(3 * c + 6 * a + 5 * e >= 23)
m.addConstr(6 * h + 5 * p + 5 * e >= 23)
m.addConstr(5 * z + 3 * c + 6 * h >= 23)
m.addConstr(6 * b + 6 * a + 5 * p >= 23)
m.addConstr(6 * a + 6 * h + 5 * e >= 23)
m.addConstr(5 * z + 3 * c + 5 * p >= 26)
m.addConstr(6 * b + 5 * p + 5 * e >= 26)
m.addConstr(3 * c + 6 * a + 5 * p >= 26)
m.addConstr(5 * z + 6 * a + 5 * p >= 26)
m.addConstr(3 * c + 6 * a + 5 * e >= 26)
m.addConstr(6 * h + 5 * p + 5 * e >= 26)
m.addConstr(5 * z + 3 * c + 6 * h >= 26)
m.addConstr(6 * b + 6 * a + 5 * p >= 26)
m.addConstr(6 * a + 6 * h + 5 * e >= 26)

# Digestive support index constraints
m.addConstr(7 * z + 6 * p <= 89)
m.addConstr(6 * p + 4 * e >= 6)
m.addConstr(6 * b + 4 * e >= 9)
m.addConstr(3 * a + 3 * h >= 4)
m.addConstr(4 * c + 3 * h >= 8)
m.addConstr(7 * z + 4 * c >= 12)
m.addConstr(7 * z + 3 * h >= 8)
m.addConstr(3 * a + 5 * p + 4 * e >= 10)
m.addConstr(4 * c + 3 * a + 4 * e >= 10)
m.addConstr(6 * b + 4 * c + 3 * h >= 10)
m.addConstr(7 * z + 4 * c + 3 * a >= 10)
m.addConstr(6 * h + 6 * p + 4 * e >= 10)
m.addConstr(4 * c + 3 * h + 4 * e >= 10)
m.addConstr(7 * z + 6 * b + 5 * p >= 10)
m.addConstr(7 * z + 3 * a + 5 * p >= 10)
m.addConstr(7 * z + 3 * a + 3 * h >= 10)
m.addConstr(4 * c + 3 * a + 3 * h >= 10)

# Cardiovascular support index constraints
m.addConstr(1 * z + 1 * b + 8 * c + 4 * a + 1 * h + 4 * p + 3 * e <= 223)

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("zinc: ", z.varValue)
    print("vitamin_B6: ", b.varValue)
    print("vitamin_C: ", c.varValue)
    print("calcium: ", a.varValue)
    print("carbohydrates: ", h.varValue)
    print("protein: ", p.varValue)
    print("iron: ", e.varValue)
else:
    print("No solution found")
