
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")

# Set objective function
model.setObjective(1.88 * dale + 7.5 * laura + 9.6 * john + 3.92 * peggy + 6.52 * hank, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(18 * laura + 17 * peggy >= 116, "c1")
model.addConstr(13 * dale + 9 * john >= 105, "c2")
model.addConstr(13 * dale + 11 * hank >= 88, "c3")
model.addConstr(18 * laura + 11 * hank >= 80, "c4")
model.addConstr(9 * john + 17 * peggy >= 96, "c5")
model.addConstr(13 * dale + 18 * laura + 9 * john >= 92, "c6")
model.addConstr(9 * john + 17 * peggy + 11 * hank >= 92, "c7")
model.addConstr(13 * dale + 18 * laura + 9 * john >= 84, "c8") # Redundant constraint
model.addConstr(9 * john + 17 * peggy + 11 * hank >= 84, "c9") # Redundant constraint
model.addConstr(18 * laura + 11 * hank <= 294, "c10")
model.addConstr(17 * peggy + 11 * hank <= 265, "c11")
model.addConstr(18 * laura + 17 * peggy <= 451, "c12")
model.addConstr(13 * dale + 9 * john <= 176, "c13")
model.addConstr(13 * dale + 18 * laura <= 481, "c14")
model.addConstr(13 * dale + 11 * hank <= 300, "c15")
model.addConstr(9 * john + 11 * hank <= 575, "c16")  # Likely redundant given individual coefficients and total constraint
model.addConstr(13 * dale + 18 * laura + 9 * john + 17 * peggy + 11 * hank <= 575, "c17")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

