
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    dale_hours = model.addVar(name="dale_hours", lb=0)
    laura_hours = model.addVar(name="laura_hours", lb=0)
    john_hours = model.addVar(name="john_hours", lb=0)
    peggy_hours = model.addVar(name="peggy_hours", lb=0)
    hank_hours = model.addVar(name="hank_hours", lb=0)

    # Define coefficients for the objective function
    obj_coeffs = {
        dale_hours: 1.88,
        laura_hours: 7.5,
        john_hours: 9.6,
        peggy_hours: 3.92,
        hank_hours: 6.52,
    }

    # Set the objective function
    model.setObjective(dale_hours * obj_coeffs[dale_hours] + 
                       laura_hours * obj_coeffs[laura_hours] + 
                       john_hours * obj_coeffs[john_hours] + 
                       peggy_hours * obj_coeffs[peggy_hours] + 
                       hank_hours * obj_coeffs[hank_hours], 
                       gurobi.GRB.MAXIMIZE)

    # Define constraints
    # Paperwork competence ratings
    dale_rating = 13
    laura_rating = 18
    john_rating = 9
    peggy_rating = 17
    hank_rating = 11

    # Constraints
    model.addConstr(laura_rating * laura_hours + peggy_rating * peggy_hours >= 116)
    model.addConstr(dale_rating * dale_hours + john_rating * john_hours >= 105)
    model.addConstr(dale_rating * dale_hours + hank_rating * hank_hours >= 88)
    model.addConstr(laura_rating * laura_hours + hank_rating * hank_hours >= 80)
    model.addConstr(john_rating * john_hours + peggy_rating * peggy_hours >= 96)
    model.addConstr(dale_rating * dale_hours + laura_rating * laura_hours + john_rating * john_hours >= 92)
    model.addConstr(john_rating * john_hours + peggy_rating * peggy_hours + hank_rating * hank_hours >= 92)
    model.addConstr(dale_rating * dale_hours + laura_rating * laura_hours + john_rating * john_hours >= 84)
    model.addConstr(john_rating * john_hours + peggy_rating * peggy_hours + hank_rating * hank_hours >= 84)
    model.addConstr(laura_rating * laura_hours + hank_rating * hank_hours <= 294)
    model.addConstr(peggy_rating * peggy_hours + hank_rating * hank_hours <= 265)
    model.addConstr(laura_rating * laura_hours + peggy_rating * peggy_hours <= 451)
    model.addConstr(dale_rating * dale_hours + john_rating * john_hours <= 176)
    model.addConstr(dale_rating * dale_hours + laura_rating * laura_hours <= 481)
    model.addConstr(dale_rating * dale_hours + hank_rating * hank_hours <= 300)
    model.addConstr(john_rating * john_hours + hank_rating * hank_hours <= 575)
    model.addConstr(dale_rating * dale_hours + laura_rating * laura_hours + john_rating * john_hours + 
                    peggy_rating * peggy_hours + hank_rating * hank_hours <= 575)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {dale_hours.varValue}")
        print(f"Hours worked by Laura: {laura_hours.varValue}")
        print(f"Hours worked by John: {john_hours.varValue}")
        print(f"Hours worked by Peggy: {peggy_hours.varValue}")
        print(f"Hours worked by Hank: {hank_hours.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
