
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition Optimization")

# Create variables
vitamin_b3 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b3")
protein = model.addVar(vtype=GRB.CONTINUOUS, name="protein")
magnesium = model.addVar(vtype=GRB.CONTINUOUS, name="magnesium")
vitamin_b1 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b1")

# Set objective function
model.setObjective(8 * vitamin_b3 + 5 * protein + 1 * magnesium + 9 * vitamin_b1, GRB.MAXIMIZE)

# Add constraints based on resource indices
resources = {
    'r0': {'description': 'energy stability index', 'upper_bound': 92, 'x0': 1.74, 'x1': 1.62, 'x2': 1.3, 'x3': 0.06},
    'r1': {'description': 'kidney support index', 'upper_bound': 146, 'x0': 1.51, 'x1': 1.51, 'x2': 1.99, 'x3': 0.64},
    'r2': {'description': 'cardiovascular support index', 'upper_bound': 117, 'x0': 1.9, 'x1': 0.67, 'x2': 1.31, 'x3': 0.15},
    'r3': {'description': 'muscle growth index', 'upper_bound': 111, 'x0': 0.06, 'x1': 0.96, 'x2': 1.58, 'x3': 1.97}
}

# Resource constraints (upper bounds are handled later)
for resource, data in resources.items():
    model.addConstr(data['x0'] * vitamin_b3 + data['x1'] * protein + data['x2'] * magnesium + data['x3'] * vitamin_b1 <= data['upper_bound'], resource)


# Add other constraints as specified in the input
model.addConstr(1.74 * vitamin_b3 + 1.3 * magnesium >= 20)
model.addConstr(1.51 * vitamin_b3 + 1.51 * protein >= 16)
model.addConstr(1.51 * protein + 0.64 * vitamin_b1 >= 30)
model.addConstr(1.51 * vitamin_b3 + 1.99 * magnesium >= 33)
model.addConstr(1.51 * protein + 1.99 * magnesium >= 24)
model.addConstr(1.51 * vitamin_b3 + 0.64 * vitamin_b1 >= 14)
model.addConstr(1.51 * vitamin_b3 + 1.51 * protein + 1.99 * magnesium >= 26)
model.addConstr(1.51 * protein + 1.99 * magnesium + 0.64 * vitamin_b1 >= 26)
model.addConstr(1.9 * vitamin_b3 + 1.31 * magnesium >= 11)
model.addConstr(1.31 * magnesium + 0.15 * vitamin_b1 >= 15)
model.addConstr(0.06 * vitamin_b3 + 1.97 * vitamin_b1 >= 27)
model.addConstr(1.58 * magnesium + 1.97 * vitamin_b1 >= 14)
model.addConstr(0.96 * protein + 1.58 * magnesium >= 13)
model.addConstr(0.06 * vitamin_b3 + 0.96 * protein >= 12)
model.addConstr(9 * vitamin_b3 - 10 * vitamin_b1 >= 0)
model.addConstr(1.62 * protein + 1.3 * magnesium <= 45)
model.addConstr(1.3 * magnesium + 0.06 * vitamin_b1 <= 53)
model.addConstr(1.62 * protein + 0.06 * vitamin_b1 <= 80)


# ... (Rest of the constraints from the input) ...


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

