
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Hours")

# Create variables
laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
george_hours = model.addVar(vtype=GRB.INTEGER, name="george_hours")
ringo_hours = model.addVar(vtype=GRB.INTEGER, name="ringo_hours")

# Set objective function
model.setObjective(3 * laura_hours + 9 * paul_hours + 6 * hank_hours + 4 * george_hours + 8 * ringo_hours, GRB.MAXIMIZE)

# Add constraints based on computer competence rating
model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours >= 23)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours >= 23)
model.addConstr(5 * paul_hours + 5 * hank_hours + 2 * ringo_hours >= 23)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours >= 23)
model.addConstr(5 * paul_hours + 1 * george_hours + 2 * ringo_hours >= 23)

model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours >= 31)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours >= 31)
model.addConstr(5 * paul_hours + 5 * hank_hours + 2 * ringo_hours >= 31)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours >= 31)
model.addConstr(5 * paul_hours + 1 * george_hours + 2 * ringo_hours >= 31)

model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours >= 25)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours >= 25)
model.addConstr(5 * paul_hours + 5 * hank_hours + 2 * ringo_hours >= 25)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours >= 25)
model.addConstr(5 * paul_hours + 1 * george_hours + 2 * ringo_hours >= 25)

model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours >= 20)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours >= 20)
model.addConstr(5 * paul_hours + 5 * hank_hours + 2 * ringo_hours >= 20)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours >= 20)
model.addConstr(5 * paul_hours + 1 * george_hours + 2 * ringo_hours >= 20)

model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours >= 24)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours >= 24)
model.addConstr(5 * paul_hours + 5 * hank_hours + 2 * ringo_hours >= 24)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours >= 24)
model.addConstr(5 * paul_hours + 1 * george_hours + 2 * ringo_hours >= 24)


# Add constraints based on likelihood to quit index
model.addConstr(4 * laura_hours + 8 * paul_hours + 6 * ringo_hours >= 16)
model.addConstr(4 * laura_hours + 5 * george_hours + 6 * ringo_hours >= 16)
model.addConstr(8 * paul_hours + 5 * george_hours + 6 * ringo_hours >= 16)

model.addConstr(4 * laura_hours + 8 * paul_hours + 6 * ringo_hours >= 23)
model.addConstr(4 * laura_hours + 5 * george_hours + 6 * ringo_hours >= 23)
model.addConstr(8 * paul_hours + 5 * george_hours + 6 * ringo_hours >= 23)

model.addConstr(4 * laura_hours + 8 * paul_hours + 6 * ringo_hours >= 15)
model.addConstr(4 * laura_hours + 5 * george_hours + 6 * ringo_hours >= 15)
model.addConstr(8 * paul_hours + 5 * george_hours + 6 * ringo_hours >= 15)


# Add upper bound constraints for combined resources
model.addConstr(5 * paul_hours + 5 * hank_hours <= 40)
model.addConstr(5 * hank_hours + 2 * ringo_hours <= 32)
model.addConstr(5 * laura_hours + 5 * paul_hours <= 34)
model.addConstr(5 * paul_hours + 1 * george_hours <= 134)
model.addConstr(5 * laura_hours + 2 * ringo_hours <= 60)
model.addConstr(5 * hank_hours + 1 * george_hours <= 112)
model.addConstr(1 * george_hours + 2 * ringo_hours <= 121)
model.addConstr(5 * paul_hours + 2 * ringo_hours <= 112)
model.addConstr(5 * laura_hours + 5 * hank_hours + 1 * george_hours <= 58)
model.addConstr(5 * laura_hours + 5 * paul_hours + 5 * hank_hours <= 121)
model.addConstr(5 * hank_hours + 1 * george_hours + 2 * ringo_hours <= 58)
model.addConstr(5 * paul_hours + 5 * hank_hours + 1 * george_hours <= 41)
model.addConstr(5 * laura_hours + 1 * george_hours + 2 * ringo_hours <= 151)
model.addConstr(5 * laura_hours + 5 * paul_hours + 2 * ringo_hours <= 148)
model.addConstr(5 * laura_hours + 5 * hank_hours + 2 * ringo_hours <= 102)
model.addConstr(5 * laura_hours + 5 * paul_hours + 1 * george_hours <= 156)
model.addConstr(5 * laura_hours + 5 * paul_hours + 5 * hank_hours + 1 * george_hours + 2 * ringo_hours <= 156)

model.addConstr(5 * george_hours + 6 * ringo_hours <= 116)
model.addConstr(4 * laura_hours + 6 * ringo_hours <= 35)
model.addConstr(8 * paul_hours + 4 * hank_hours <= 128)
model.addConstr(8 * paul_hours + 5 * george_hours <= 63)
model.addConstr(4 * laura_hours + 4 * hank_hours + 6 * ringo_hours <= 83)
model.addConstr(4 * laura_hours + 4 * hank_hours + 5 * george_hours <= 82)
model.addConstr(8 * paul_hours + 4 * hank_hours + 5 * george_hours <= 74)
model.addConstr(4 * hank_hours + 5 * george_hours + 6 * ringo_hours <= 101)
model.addConstr(4 * laura_hours + 5 * george_hours + 6 * ringo_hours <= 108)
model.addConstr(8 * paul_hours + 4 * hank_hours + 6 * ringo_hours <= 57)
model.addConstr(8 * paul_hours + 5 * george_hours + 6 * ringo_hours <= 95)
model.addConstr(4 * laura_hours + 8 * paul_hours + 5 * george_hours <= 120)
model.addConstr(4 * laura_hours + 8 * paul_hours + 4 * hank_hours + 5 * george_hours + 6 * ringo_hours <= 120)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
