
import gurobipy as gp

# Create a new model
m = gp.Model("muscle_growth_optimization")

# Create variables
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")

# Set objective function
m.setObjective(3.58 * vitamin_e + 5.69 * fat + 3.28 * protein + 2.48 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * vitamin_e + 14 * fat + 13 * vitamin_b4 >= 40, "c1")
m.addConstr(11 * vitamin_e + 11 * protein + 13 * vitamin_b4 >= 40, "c2")
m.addConstr(11 * vitamin_e + 14 * fat + 13 * vitamin_b4 >= 36, "c3")
m.addConstr(11 * vitamin_e + 11 * protein + 13 * vitamin_b4 >= 36, "c4")
m.addConstr(11 * vitamin_e + 11 * protein <= 124, "c5")
m.addConstr(11 * protein + 13 * vitamin_b4 <= 146, "c6")
m.addConstr(11 * vitamin_e + 14 * fat <= 152, "c7")
m.addConstr(14 * fat + 13 * vitamin_b4 <= 81, "c8")
m.addConstr(11 * vitamin_e + 14 * fat + 11 * protein + 13 * vitamin_b4 <= 171, "c9") #Resource constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_e:', vitamin_e.x)
    print('fat:', fat.x)
    print('protein:', protein.x)
    print('vitamin_b4:', vitamin_b4.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

