
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_E")
x1 = m.addVar(lb=0, name="grams_of_fat")
x2 = m.addVar(lb=0, name="grams_of_protein")
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_B4")

# Define the objective function
m.setObjective(3.58*x0 + 5.69*x1 + 3.28*x2 + 2.48*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 14*x1 + 13*x3 >= 40, name="constraint_1")
m.addConstr(11*x0 + 11*x2 + 13*x3 >= 40, name="constraint_2")
m.addConstr(11*x0 + 14*x1 + 13*x3 >= 36, name="constraint_3")
m.addConstr(11*x0 + 11*x2 + 13*x3 >= 36, name="constraint_4")
m.addConstr(11*x0 + 11*x2 <= 124, name="constraint_5")
m.addConstr(11*x2 + 13*x3 <= 146, name="constraint_6")
m.addConstr(11*x0 + 14*x1 <= 152, name="constraint_7")
m.addConstr(14*x1 + 13*x3 <= 81, name="constraint_8")
m.addConstr(11*x0 + 14*x1 + 11*x2 + 13*x3 <= 171, name="constraint_9")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"milligrams_of_vitamin_E: {x0.x}")
    print(f"grams_of_fat: {x1.x}")
    print(f"grams_of_protein: {x2.x}")
    print(f"milligrams_of_vitamin_B4: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
