
import gurobipy as gp

# Create a new model
m = gp.Model("muscle_growth")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_E", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="grams_of_fat", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="grams_of_protein", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_vitamin_B4", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(3.58*x0 + 5.69*x1 + 3.28*x2 + 2.48*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(11*x0 <= 171, name="vitamin_E_constraint")
m.addConstr(14*x1 <= 171, name="fat_constraint")
m.addConstr(11*x2 <= 171, name="protein_constraint")
m.addConstr(13*x3 <= 171, name="vitamin_B4_constraint")

m.addConstr(11*x0 + 14*x1 + 13*x3 >= 40, name="combined_constraint_1")
m.addConstr(11*x0 + 11*x2 + 13*x3 >= 40, name="combined_constraint_2")
m.addConstr(11*x0 + 14*x1 + 13*x3 >= 36, name="combined_constraint_3")
m.addConstr(11*x0 + 11*x2 + 13*x3 >= 36, name="combined_constraint_4")

m.addConstr(11*x0 + 11*x2 <= 124, name="protein_vitamin_E_constraint")
m.addConstr(11*x2 + 13*x3 <= 146, name="protein_vitamin_B4_constraint")
m.addConstr(11*x0 + 14*x1 <= 152, name="vitamin_E_fat_constraint")
m.addConstr(14*x1 + 13*x3 <= 81, name="fat_vitamin_B4_constraint")
m.addConstr(11*x0 + 14*x1 + 11*x2 + 13*x3 <= 81, name="all_variables_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of vitamin E: {x0.varValue}")
    print(f"Grams of fat: {x1.varValue}")
    print(f"Grams of protein: {x2.varValue}")
    print(f"Milligrams of vitamin B4: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
