
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b3 = model.addVar(vtype=GRB.CONTINUOUS, name="b3")  # milligrams of vitamin B3
b9 = model.addVar(vtype=GRB.CONTINUOUS, name="b9")  # milligrams of vitamin B9
b5 = model.addVar(vtype=GRB.CONTINUOUS, name="b5")  # milligrams of vitamin B5
b7 = model.addVar(vtype=GRB.CONTINUOUS, name="b7")  # milligrams of vitamin B7

# Set objective function
model.setObjective(7 * b3 + 6 * b9 + 9 * b5 + 8 * b7, GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * b3 + 14 * b7 >= 32, "c1")
model.addConstr(11 * b9 + 14 * b7 >= 17, "c2")
model.addConstr(10 * b5 + 14 * b7 >= 40, "c3")
model.addConstr(1 * b3 + 11 * b9 >= 44, "c4")
model.addConstr(11 * b9 + 10 * b5 >= 19, "c5")
model.addConstr(1 * b3 + 11 * b9 + 10 * b5 + 14 * b7 >= 19, "c6")
model.addConstr(16 * b9 + 12 * b7 >= 26, "c7")
model.addConstr(11 * b3 + 12 * b5 >= 43, "c8")
model.addConstr(16 * b9 + 12 * b5 >= 51, "c9")
model.addConstr(11 * b3 + 12 * b7 >= 52, "c10")
model.addConstr(11 * b3 + 16 * b9 + 12 * b5 >= 35, "c11")
model.addConstr(11 * b3 + 16 * b9 + 12 * b5 + 12 * b7 >= 35, "c12")
model.addConstr(-1 * b3 + 8 * b9 >= 0, "c13")
model.addConstr(-5 * b5 + 1 * b7 >= 0, "c14")
model.addConstr(-8 * b9 + 6 * b7 >= 0, "c15")

model.addConstr(11 * b9 + 14 * b7 <= 147, "c16")
model.addConstr(1 * b3 + 11 * b9 <= 191, "c17")
model.addConstr(1 * b3 + 14 * b7 <= 102, "c18")
model.addConstr(10 * b5 + 14 * b7 <= 160, "c19")
model.addConstr(1 * b3 + 10 * b5 <= 92, "c20")
model.addConstr(1 * b3 + 10 * b5 + 14 * b7 <= 185, "c21")
model.addConstr(11 * b3 + 16 * b9 <= 230, "c22")
model.addConstr(16 * b9 + 12 * b5 <= 144, "c23")
model.addConstr(16 * b9 + 12 * b7 <= 227, "c24")
model.addConstr(11 * b3 + 12 * b7 <= 151, "c25")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Objective Value:', model.objVal)
    for v in model.getVars():
        print(f'{v.varName}: {v.x}')
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

