
from gurobipy import *

# Create a model
m = Model("Vitamin_Optimization")

# Define variables (all are continuous)
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='milligrams_of_vitamin_B3')
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='milligrams_of_vitamin_B9')
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='milligrams_of_vitamin_B5')
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='milligrams_of_vitamin_B7')

# Objective function
m.setObjective(7*x0 + 6*x1 + 9*x2 + 8*x3, GRB.MINIMIZE)

# Constraints based on the description (example constraints)
# Cognitive performance index constraints
m.addConstr(x0 + x3 >= 32, name='cognitive_performance_B3_B7')
m.addConstr(x1 + x3 >= 17, name='cognitive_performance_B9_B7')
m.addConstr(x2 + x3 >= 40, name='cognitive_performance_B5_B7')
m.addConstr(x0 + x1 >= 44, name='cognitive_performance_B3_B9')
m.addConstr(x1 + x2 >= 19, name='cognitive_performance_B9_B5')
m.addConstr(x0 + x1 + x2 + x3 >= 19, name='total_cognitive_performance')

# Digestive support index constraints
m.addConstr(11*x0 + 12*x2 >= 43, name='digestive_support_B3_B5')
m.addConstr(16*x1 + 12*x2 >= 51, name='digestive_support_B9_B5')
m.addConstr(11*x0 + 14*x3 >= 52, name='digestive_support_B3_B7')
m.addConstr(11*x0 + 16*x1 + 12*x2 >= 35, name='total_digestive_support_B3_B9_B5')
m.addConstr(11*x0 + 16*x1 + 12*x2 + 12*x3 >= 35, name='total_digestive_support')

# Additional constraints
m.addConstr(-x0 + 8*x1 >= 0, name='additional_constraint_1')
m.addConstr(-5*x2 + x3 >= 0, name='additional_constraint_2')
m.addConstr(-8*x1 + 6*x3 >= 0, name='additional_constraint_3')

# Upper bounds for cognitive performance indices
m.addConstr(x1 + x3 <= 147, name='upper_bound_cognitive_B9_B7')
m.addConstr(x0 + x1 <= 191, name='upper_bound_cognitive_B3_B9')
m.addConstr(x0 + x3 <= 102, name='upper_bound_cognitive_B3_B7')
m.addConstr(x2 + x3 <= 160, name='upper_bound_cognitive_B5_B7')
m.addConstr(x0 + x2 <= 92, name='upper_bound_cognitive_B3_B5')
m.addConstr(x0 + x2 + x3 <= 185, name='upper_bound_total_cognitive_B3_B5_B7')

# Upper bounds for digestive support indices
m.addConstr(11*x0 + 16*x1 <= 230, name='upper_bound_digestive_B3_B9')
m.addConstr(16*x1 + 12*x2 <= 144, name='upper_bound_digestive_B9_B5')
m.addConstr(16*x1 + 12*x3 <= 227, name='upper_bound_digestive_B9_B7')
m.addConstr(11*x0 + 14*x3 <= 151, name='upper_bound_digestive_B3_B7')

# Optimize the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
