
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams of vitamin B3", lb=0)
    x1 = model.addVar(name="milligrams of vitamin B9", lb=0)
    x2 = model.addVar(name="milligrams of vitamin B5", lb=0)
    x3 = model.addVar(name="milligrams of vitamin B7", lb=0)

    # Define the objective function
    model.setObjective(7 * x0 + 6 * x1 + 9 * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x0 + 11 * x1 + 10 * x2 + 14 * x3 <= 202)
    model.addConstr(11 * x0 + 16 * x1 + 12 * x2 + 12 * x3 <= 275)
    model.addConstr(x0 + x3 >= 32)
    model.addConstr(x1 + x3 >= 17)
    model.addConstr(x2 + x3 >= 40)
    model.addConstr(x0 + x1 >= 44)
    model.addConstr(x1 + x2 >= 19)
    model.addConstr(x0 + x1 + x2 + x3 >= 19)
    model.addConstr(x1 + x3 >= 26)
    model.addConstr(11 * x0 + 12 * x2 >= 43)
    model.addConstr(16 * x1 + 12 * x2 >= 51)
    model.addConstr(11 * x0 + 12 * x3 >= 52)
    model.addConstr(11 * x0 + 16 * x1 + 12 * x2 >= 35)
    model.addConstr(11 * x0 + 16 * x1 + 12 * x2 + 12 * x3 >= 35)
    model.addConstr(-x0 + 8 * x1 >= 0)
    model.addConstr(-5 * x2 + x3 >= 0)
    model.addConstr(-8 * x1 + 6 * x3 >= 0)
    model.addConstr(x1 + x3 <= 147)
    model.addConstr(x0 + x1 <= 191)
    model.addConstr(x0 + x3 <= 102)
    model.addConstr(x2 + x3 <= 160)
    model.addConstr(x0 + x2 <= 92)
    model.addConstr(x0 + x2 + x3 <= 185)
    model.addConstr(11 * x0 + 16 * x1 <= 230)
    model.addConstr(16 * x1 + 12 * x2 <= 144)
    model.addConstr(16 * x1 + 12 * x3 <= 227)
    model.addConstr(11 * x0 + 12 * x3 <= 151)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B3: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Milligrams of vitamin B7: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
