
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
bandwidth_monitoring = m.addVar(vtype=GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="SOC operators")

# Set objective function
m.setObjective(3.42 * automatic_alerts + 4.6 * bandwidth_monitoring + 9.52 * soc_operators, GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * automatic_alerts + 3 * bandwidth_monitoring + 6 * soc_operators <= 108, "r0_network_latency_impact")  # Network latency impact
m.addConstr(7 * automatic_alerts + 3 * bandwidth_monitoring + 4 * soc_operators <= 75, "r1_available_bandwidth_impact")  # Available bandwidth impact

m.addConstr(8 * automatic_alerts + 6 * soc_operators >= 21, "latency_alerts_operators_min")
m.addConstr(8 * automatic_alerts + 3 * bandwidth_monitoring >= 23, "latency_alerts_bandwidth_min")
m.addConstr(8 * automatic_alerts + 3 * bandwidth_monitoring + 6 * soc_operators >= 32, "latency_all_min")

m.addConstr(7 * automatic_alerts + 3 * bandwidth_monitoring >= 13, "bandwidth_alerts_bandwidth_min")
m.addConstr(3 * bandwidth_monitoring + 4 * soc_operators >= 17, "bandwidth_bandwidth_operators_min")
m.addConstr(7 * automatic_alerts + 3 * bandwidth_monitoring + 4 * soc_operators >= 17, "bandwidth_all_min")

m.addConstr(3 * bandwidth_monitoring - 7 * soc_operators >= 0, "bandwidth_operators_relation")
m.addConstr(5 * automatic_alerts - 8 * soc_operators >= 0, "alerts_operators_relation")

m.addConstr(8 * automatic_alerts + 6 * soc_operators <= 79, "latency_alerts_operators_max")
m.addConstr(3 * bandwidth_monitoring + 6 * soc_operators <= 55, "latency_bandwidth_operators_max")
m.addConstr(7 * automatic_alerts + 3 * bandwidth_monitoring <= 65, "bandwidth_alerts_bandwidth_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('automatic_alerts:', automatic_alerts.x)
    print('bandwidth_monitoring:', bandwidth_monitoring.x)
    print('soc_operators:', soc_operators.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

