
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="automatic_alerts", vtype=gp.GRB.INTEGER, lb=0)  # Nonfractional
x1 = m.addVar(name="Mbps_bandwidth_allocated_to_monitoring", vtype=gp.GRB.INTEGER, lb=0)  # Integer
x2 = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER, lb=0)  # Nonfractional

# Objective function
m.setObjective(3.42 * x0 + 4.6 * x1 + 9.52 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8 * x0 + 6 * x2 >= 21)  # Constraint 1
m.addConstr(8 * x0 + 3 * x1 >= 23)  # Constraint 2
m.addConstr(8 * x0 + 3 * x1 + 6 * x2 >= 32)  # Constraint 3
m.addConstr(7 * x0 + 3 * x1 >= 13)  # Constraint 4
m.addConstr(3 * x1 + 4 * x2 >= 17)  # Constraint 5
m.addConstr(7 * x0 + 3 * x1 + 4 * x2 >= 17)  # Constraint 6
m.addConstr(3 * x1 - 7 * x2 >= 0)  # Constraint 7
m.addConstr(5 * x0 - 8 * x2 >= 0)  # Constraint 8
m.addConstr(8 * x0 + 6 * x2 <= 79)  # Constraint 9
m.addConstr(3 * x1 + 6 * x2 <= 55)  # Constraint 10
m.addConstr(7 * x0 + 3 * x1 <= 65)  # Constraint 11

# Resource constraints
m.addConstr(8 * x0 + 3 * x1 + 6 * x2 <= 108, name="r0")  # Resource r0
m.addConstr(7 * x0 + 3 * x1 + 4 * x2 <= 75, name="r1")  # Resource r1

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Automatic Alerts: {x0.varValue}")
    print(f"Mbps Bandwidth Allocated to Monitoring: {x1.varValue}")
    print(f"SOC Operators: {x2.varValue}")
    print(f"Objective Value: {m.objVal}")
else:
    print("The model is infeasible.")
