
from gurobipy import Model, GRB

# Create a new model
m = Model("Ringo_John_Work_Optimization")

# Create variables
ringo_hours = m.addVar(vtype=GRB.INTEGER, name="ringo_hours")
john_hours = m.addVar(vtype=GRB.CONTINUOUS, name="john_hours")

# Set objective function
m.setObjective(9 * ringo_hours + 2 * john_hours, GRB.MINIMIZE)

# Add constraints

# Productivity
m.addConstr(6 * ringo_hours + 12 * john_hours >= 52, "productivity_min")
m.addConstr(6 * ringo_hours + 12 * john_hours <= 94, "productivity_max")

# Cost
m.addConstr(7 * ringo_hours + 11 * john_hours >= 52, "cost_min")
m.addConstr(7 * ringo_hours + 11 * john_hours <= 70, "cost_max")

# Likelihood to quit
m.addConstr(5 * ringo_hours + 11 * john_hours >= 21, "quit_min")
m.addConstr(5 * ringo_hours + 11 * john_hours <= 61, "quit_max")

# Paperwork competence
m.addConstr(9 * ringo_hours + 14 * john_hours >= 21, "paperwork_min")
m.addConstr(9 * ringo_hours + 14 * john_hours <= 37, "paperwork_max")

# Additional constraint
m.addConstr(-8 * ringo_hours + 5 * john_hours >= 0, "additional_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    print('Ringo hours:', ringo_hours.x)
    print('John hours:', john_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

