
from gurobipy import *

# Create a model
model = Model("Optimization_Problem")

# Define variables
hours_worked_by_Ringo = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
hours_worked_by_John = model.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")

# Objective function
model.setObjective(9 * hours_worked_by_Ringo + 2 * hours_worked_by_John, GRB.MINIMIZE)

# Constraints
model.addConstr((6 * hours_worked_by_Ringo) + (12 * hours_worked_by_John) >= 52, name="productivity_min")
model.addConstr((6 * hours_worked_by_Ringo) + (12 * hours_worked_by_John) <= 94, name="productivity_max")

model.addConstr((7 * hours_worked_by_Ringo) + (11 * hours_worked_by_John) >= 52, name="dollar_cost_min")
model.addConstr((7 * hours_worked_by_Ringo) + (11 * hours_worked_by_John) <= 70, name="dollar_cost_max")

model.addConstr((5 * hours_worked_by_Ringo) + (11 * hours_worked_by_John) >= 21, name="quit_index_min")
model.addConstr((5 * hours_worked_by_Ringo) + (11 * hours_worked_by_John) <= 61, name="quit_index_max")

model.addConstr((9 * hours_worked_by_Ringo) + (14 * hours_worked_by_John) >= 21, name="paperwork_min")
model.addConstr((9 * hours_worked_by_Ringo) + (14 * hours_worked_by_John) <= 37, name="paperwork_max")

model.addConstr(-8 * hours_worked_by_Ringo + 5 * hours_worked_by_John >= 0, name="additional_constraint")

# Solve the model
model.optimize()

# Print solution if optimal
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {hours_worked_by_Ringo.X}")
    print(f"Hours worked by John: {hours_worked_by_John.X}")
else:
    print("No optimal solution found.")
