
import gurobi as gp

# Define the model
model = gp.Model("Optimization_Problem")

# Define the variables
R = model.addVar(name="Ringo_hours", vtype=gp.GRB.INTEGER)  # Integer hours for Ringo
J = model.addVar(name="John_hours")  # Continuous hours for John

# Define the objective function
model.setObjective(9 * R + 2 * J, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * R + 12 * J >= 52, name="Productivity_rating_min")
model.addConstr(7 * R + 11 * J >= 52, name="Dollar_cost_min")
model.addConstr(5 * R + 11 * J >= 21, name="Likelihood_to_quit_min")
model.addConstr(9 * R + 14 * J >= 21, name="Paperwork_competence_min")

model.addConstr(6 * R + 12 * J <= 94, name="Productivity_rating_max")
model.addConstr(7 * R + 11 * J <= 70, name="Dollar_cost_max")
model.addConstr(5 * R + 11 * J <= 61, name="Likelihood_to_quit_max")
model.addConstr(9 * R + 14 * J <= 37, name="Paperwork_competence_max")

model.addConstr(-8 * R + 5 * J >= 0, name="Linear_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ringo's hours: {R.varValue}")
    print(f"John's hours: {J.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
