
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
ravioli = m.addVar(vtype=GRB.INTEGER, name="ravioli")
rotisserie_chickens = m.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Set objective function
m.setObjective(5.73 * ravioli * ravioli + 1.63 * rotisserie_chickens, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * ravioli + 18 * rotisserie_chickens <= 173, "c0_healthiness")  # Resource constraint: healthiness
m.addConstr(19 * ravioli + 4 * rotisserie_chickens <= 225, "c1_protein")  # Resource constraint: protein
m.addConstr(7 * ravioli + 25 * rotisserie_chickens <= 122, "c2_sourness")  # Resource constraint: sourness
m.addConstr(16 * ravioli + 23 * rotisserie_chickens <= 245, "c3_fiber")  # Resource constraint: fiber
m.addConstr(15 * ravioli + 7 * rotisserie_chickens <= 207, "c4_iron")  # Resource constraint: iron

m.addConstr(4 * ravioli * ravioli + 18 * rotisserie_chickens * rotisserie_chickens >= 57, "c5_combined_healthiness")
m.addConstr(19 * ravioli + 4 * rotisserie_chickens >= 67, "c6_combined_protein")
m.addConstr(7 * ravioli + 25 * rotisserie_chickens >= 47, "c7_combined_sourness")
m.addConstr(16 * ravioli * ravioli + 23 * rotisserie_chickens * rotisserie_chickens >= 108, "c8_combined_fiber")
m.addConstr(15 * ravioli + 7 * rotisserie_chickens >= 65, "c9_combined_iron")

m.addConstr(-9 * ravioli + 2 * rotisserie_chickens >= 0, "c10")
m.addConstr(4 * ravioli + 18 * rotisserie_chickens <= 100, "c11_combined_healthiness_upper")
m.addConstr(19 * ravioli + 4 * rotisserie_chickens <= 158, "c12_combined_protein_upper")
m.addConstr(7 * ravioli + 25 * rotisserie_chickens <= 119, "c13_combined_sourness_upper")
m.addConstr(16 * ravioli + 23 * rotisserie_chickens <= 197, "c14_combined_fiber_upper")
m.addConstr(15 * ravioli + 7 * rotisserie_chickens <= 149, "c15_combined_iron_upper")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

