
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    ravioli = model.addVar(name="ravioli", lb=0, type=gurobi.GRB.INTEGER)
    rotisserie_chickens = model.addVar(name="rotisserie_chickens", lb=0)

    # Objective function
    model.setObjective(5.73 * ravioli ** 2 + 1.63 * rotisserie_chickens, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * ravioli + 18 * rotisserie_chickens <= 100, name="healthiness_rating")
    model.addConstr(19 * ravioli + 4 * rotisserie_chickens >= 67, name="protein_min")
    model.addConstr(19 * ravioli + 4 * rotisserie_chickens <= 158, name="protein_max")
    model.addConstr(7 * ravioli + 25 * rotisserie_chickens >= 47, name="sourness_index_min")
    model.addConstr(7 * ravioli + 25 * rotisserie_chickens <= 119, name="sourness_index_max")
    model.addConstr(16 * ravioli + 23 * rotisserie_chickens >= 108, name="fiber_min")
    model.addConstr(16 * ravioli + 23 * rotisserie_chickens <= 197, name="fiber_max")
    model.addConstr(15 * ravioli + 7 * rotisserie_chickens >= 65, name="iron_min")
    model.addConstr(15 * ravioli + 7 * rotisserie_chickens <= 149, name="iron_max")
    model.addConstr(-9 * ravioli + 2 * rotisserie_chickens >= 0, name="linear_constraint")
    model.addConstr(4 * ravioli ** 2 + 18 * rotisserie_chickens ** 2 >= 57, name="quadratic_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ravioli: {ravioli.varValue}")
        print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
