
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
vitamin_k = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_k")
vitamin_b2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b2")
vitamin_b7 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")
potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")

# Set objective function
obj = (1*fiber*fiber + 4*fiber*vitamin_k + 2*fiber*vitamin_b7 + 8*fiber*potassium +
       4*vitamin_k*vitamin_b2 + 9*vitamin_k*vitamin_b7 + 7*vitamin_k*potassium +
       3*vitamin_b2*vitamin_b2 + 7*vitamin_b2*vitamin_b7 + 3*vitamin_b2*potassium +
       3*vitamin_b7*vitamin_b7 + 5*vitamin_b7*potassium + 2*potassium*potassium +
       2*vitamin_k + 9*vitamin_b2 + 3*vitamin_b7 + 2*potassium)

model.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*fiber + 5*potassium >= 33, "c0")
model.addConstr(4*vitamin_k*vitamin_k + 3*vitamin_b2*vitamin_b2 >= 32, "c1")
model.addConstr(4*fiber + 3*vitamin_b2 >= 21, "c2")
model.addConstr(4*vitamin_k + 2*vitamin_b7 >= 28, "c3")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 2*vitamin_b7 >= 16, "c4")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 5*potassium >= 16, "c5")
model.addConstr(3*vitamin_b2 + 2*vitamin_b7 + 5*potassium >= 16, "c6")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 2*vitamin_b7 >= 28, "c7")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 5*potassium >= 28, "c8")
model.addConstr(3*vitamin_b2*vitamin_b2 + 2*vitamin_b7*vitamin_b7 + 5*potassium*potassium >= 28, "c9")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 2*vitamin_b7 >= 32, "c10")
model.addConstr(4*vitamin_k + 3*vitamin_b2 + 5*potassium >= 32, "c11")
model.addConstr(3*vitamin_b2 + 2*vitamin_b7 + 5*potassium >= 32, "c12")
model.addConstr(2*vitamin_k + 4*vitamin_b2 + 7*vitamin_b7 >= 16, "c13")
model.addConstr(3*fiber + 2*vitamin_k + 4*vitamin_b2 >= 16, "c14")
model.addConstr(2*vitamin_k + 4*vitamin_b2 + 7*vitamin_b7 >= 24, "c15")
model.addConstr(3*fiber + 2*vitamin_k + 4*vitamin_b2 >= 24, "c16")
model.addConstr(2*vitamin_b7*vitamin_b7 + 5*potassium*potassium <= 62, "c17")
model.addConstr(4*vitamin_k*vitamin_k + 3*vitamin_b2*vitamin_b2 <= 112, "c18")
model.addConstr(4*fiber*fiber + 4*vitamin_k*vitamin_k + 5*potassium*potassium <= 134, "c19")
model.addConstr(4*fiber*fiber + 3*vitamin_b2*vitamin_b2 + 2*vitamin_b7*vitamin_b7 <= 46, "c20")
model.addConstr(4*fiber + 2*vitamin_b7 + 5*potassium <= 111, "c21")
model.addConstr(3*vitamin_b2 + 2*vitamin_b7 + 5*potassium <= 83, "c22")
model.addConstr(4*vitamin_k*vitamin_k + 3*vitamin_b2*vitamin_b2 + 2*vitamin_b7*vitamin_b7 <= 72, "c23")
model.addConstr(4*fiber + 4*vitamin_k + 3*vitamin_b2 + 2*vitamin_b7 + 5*potassium <= 72, "c24")
model.addConstr(3*fiber + 4*vitamin_b2 <= 138, "c25")
model.addConstr(7*vitamin_b7 + 1*potassium <= 156, "c26")
model.addConstr(3*fiber + 2*vitamin_k <= 37, "c27")
model.addConstr(2*vitamin_k + 1*potassium <= 38, "c28")
model.addConstr(3*fiber + 7*vitamin_b7 <= 120, "c29")
model.addConstr(3*fiber*fiber + 1*potassium*potassium <= 104, "c30")
model.addConstr(4*vitamin_b2 + 7*vitamin_b7 <= 53, "c31")
model.addConstr(4*vitamin_b2 + 1*potassium <= 33, "c32")
model.addConstr(3*fiber + 7*vitamin_b7 + 1*potassium <= 73, "c33")
model.addConstr(3*fiber + 2*vitamin_k + 7*vitamin_b7 <= 103, "c34")
model.addConstr(3*fiber + 2*vitamin_k + 1*potassium <= 42, "c35")
model.addConstr(4*vitamin_b2*vitamin_b2 + 7*vitamin_b7*vitamin_b7 + 1*potassium*potassium <= 78, "c36")
model.addConstr(2*vitamin_k + 4*vitamin_b2 + 1*potassium <= 76, "c37")
model.addConstr(3*fiber*fiber + 4*vitamin_b2*vitamin_b2 + 7*vitamin_b7*vitamin_b7 <= 56, "c38")
model.addConstr(3*fiber + 2*vitamin_k + 4*vitamin_b2 <= 111, "c39")
model.addConstr(2*vitamin_k + 4*vitamin_b2 + 7*vitamin_b7 <= 140, "c40")
model.addConstr(2*vitamin_k*vitamin_k + 7*vitamin_b7*vitamin_b7 + 1*potassium*potassium <= 85, "c41")
model.addConstr(3*fiber + 2*vitamin_k + 4*vitamin_b2 + 7*vitamin_b7 + 1*potassium <= 85, "c42")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

