
import gurobi as gp

# Create a new model
m = gp.Model()

# Define variables
f = m.addVar(name="grams of fiber", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
k = m.addVar(name="mg of vitamin K", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
b2 = m.addVar(name="mg of vitamin B2", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
b7 = m.addVar(name="mg of vitamin B7", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
p = m.addVar(name="mg of potassium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(1 * f**2 + 4 * f * k + 2 * f * b7 + 8 * f * p + 
               4 * k * b2 + 9 * k * b7 + 7 * k * p + 
               3 * b2**2 + 7 * b2 * b7 + 3 * b2 * p + 
               3 * b7**2 + 5 * b7 * p + 
               2 * p**2 + 
               2 * k + 9 * b2 + 3 * b7 + 2 * p, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4 * f <= 169)
m.addConstr(3 * f <= 160)
m.addConstr(4 * k <= 169)
m.addConstr(2 * k <= 160)
m.addConstr(3 * b2 <= 169)
m.addConstr(4 * b2 <= 160)
m.addConstr(2 * b7 <= 169)
m.addConstr(7 * b7 <= 160)
m.addConstr(5 * p <= 169)
m.addConstr(p <= 160)

m.addConstr(4 * f + 5 * p >= 33)
m.addConstr(k**2 + b2**2 >= 32)
m.addConstr(4 * f + 3 * b2 >= 21)
m.addConstr(k + 2 * b7 >= 28)
m.addConstr(k + b2 + b7 >= 16)
m.addConstr(k + b2 + p >= 16)
m.addConstr(b2 + b7 + p >= 16)
m.addConstr(k + b2 + b7 >= 28)
m.addConstr(k + b2 + p >= 28)
m.addConstr(b2**2 + b7**2 + p**2 >= 28)
m.addConstr(k + b2 + b7 >= 32)
m.addConstr(k + b2 + p >= 32)
m.addConstr(b2 + b7 + p >= 32)

m.addConstr(k + b2 + b7 >= 16)
m.addConstr(3 * f + k + b2 >= 16)
m.addConstr(k + b2 + b7 >= 24)
m.addConstr(3 * f + k + b2 >= 24)

m.addConstr(b7**2 + p**2 <= 62)
m.addConstr(k**2 + b2**2 <= 112)
m.addConstr(f**2 + k**2 + p**2 <= 134)
m.addConstr(f**2 + b2**2 + b7**2 <= 46)
m.addConstr(f + b7 + p <= 111)
m.addConstr(b2 + b7 + p <= 83)
m.addConstr(k**2 + b2**2 + b7**2 <= 72)
m.addConstr(f + k + b2 + b7 + p <= 72)

m.addConstr(3 * f + 4 * b2 <= 138)
m.addConstr(b7 + p <= 156)
m.addConstr(3 * f + k <= 37)
m.addConstr(k + p <= 38)
m.addConstr(f + b7 <= 120)
m.addConstr(f**2 + p**2 <= 104)
m.addConstr(b2 + b7 <= 53)
m.addConstr(b2 + p <= 33)
m.addConstr(f + b7 + p <= 73)
m.addConstr(f + k + b7 <= 103)
m.addConstr(f + k + p <= 42)

# Solve the model
m.optimize()

# Print the objective function value
print("Objective: ", m.objVal)

# Print the variable values
print("Grams of fiber: ", f.varValue)
print("Mg of vitamin K: ", k.varValue)
print("Mg of vitamin B2: ", b2.varValue)
print("Mg of vitamin B7: ", b7.varValue)
print("Mg of potassium: ", p.varValue)
