
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (quantities)
x0 = m.addVar(vtype=GRB.INTEGER, name="potato_vines")  # Potato vines
x1 = m.addVar(vtype=GRB.INTEGER, name="apple_trees")   # Apple trees
x2 = m.addVar(vtype=GRB.INTEGER, name="squash_plants") # Squash plants
x3 = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")  # Cherry trees
x4 = m.addVar(vtype=GRB.INTEGER, name="carrots")       # Carrots
x5 = m.addVar(vtype=GRB.INTEGER, name="coleus")        # Coleus

# Objective function: Maximize the total value
m.setObjective(1.4*x0 + 7.22*x1 + 1.36*x2 + 2.36*x3 + 7.91*x4 + 2.85*x5, GRB.MAXIMIZE)

# Budget constraints (example)
m.addConstr(10*x0 + 20*x1 + 15*x2 + 25*x3 + 30*x4 + 5*x5 <= 125)  # Total budget constraint
m.addConstr(x1 + x4 <= 128 / (20 + 30))                            # Spend no more than $128 on apple trees plus carrots
m.addConstr(10*x0 + 25*x3 <= 124)                                  # Spend no more than $124 on potato vines plus cherry trees

# Beauty rating constraints (example lower bounds)
m.addConstr(x2 + x5 >= 17)                                         # Total beauty rating from squash plants and coleus must be at least 17
m.addConstr(x0 + x1 + x2 >= 12)                                    # Total beauty rating from potato vines, apple trees, and squash plants must be at least 12

# Additional constraints (example)
m.addConstr(10*x0 <= 41 / 10)                                      # Spend no more than $41 on potato vines
m.addConstr(x1 + x5 <= 90 / (20 + 5))                              # Spend no more than $90 on apple trees and coleus

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
