
from gurobipy import Model, GRB

# Create a new model
model = Model("resource_allocation")

# Create variables
paul_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paul_hours")
ringo_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="ringo_hours")

# Set objective function
model.setObjective(1.67 * paul_hours * ringo_hours + 6.79 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(19 * paul_hours**2 + 2 * ringo_hours**2 >= 44, "paperwork_competence_squared")
model.addConstr(19 * paul_hours + 2 * ringo_hours >= 44, "paperwork_competence")
model.addConstr(18 * paul_hours + 7 * ringo_hours >= 31, "dollar_cost")
model.addConstr(14 * paul_hours + 14 * ringo_hours >= 56, "organization_score")
model.addConstr(13 * paul_hours + 18 * ringo_hours >= 46, "computer_competence")
model.addConstr(6 * paul_hours - 10 * ringo_hours >= 0, "custom_constraint")
model.addConstr(19 * paul_hours + 2 * ringo_hours <= 94, "paperwork_competence_upper")
model.addConstr(18 * paul_hours + 7 * ringo_hours <= 82, "dollar_cost_upper")
model.addConstr(14 * paul_hours**2 + 14 * ringo_hours**2 <= 119, "organization_score_squared_upper")
model.addConstr(13 * paul_hours + 18 * ringo_hours <= 93, "computer_competence_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Paul's hours = {paul_hours.x}, Ringo's hours = {ringo_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

