
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Paul", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Ringo")

    # Objective function
    model.setObjective(1.67 * x0 * x1 + 6.79 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(19**2 * x0**2 + 2**2 * x1**2 >= 44, name="paperwork_competence_rating_squared")
    model.addConstr(19 * x0 + 2 * x1 >= 44, name="paperwork_competence_rating")
    model.addConstr(18 * x0 + 7 * x1 >= 31, name="dollar_cost_per_hour")
    model.addConstr(14 * x0 + 14 * x1 >= 56, name="organization_score")
    model.addConstr(13 * x0 + 18 * x1 >= 46, name="computer_competence_rating")
    model.addConstr(6 * x0 - 10 * x1 >= 0, name="six_times_paul_minus_ten_times_ringo")
    model.addConstr(19 * x0 + 2 * x1 <= 94, name="paperwork_competence_rating_upper_bound")
    model.addConstr(18 * x0 + 7 * x1 <= 82, name="dollar_cost_per_hour_upper_bound")
    model.addConstr(14**2 * x0**2 + 14**2 * x1**2 <= 119, name="organization_score_squared_upper_bound")
    model.addConstr(13 * x0 + 18 * x1 <= 93, name="computer_competence_rating_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x0.varValue}")
        print(f"Hours worked by Ringo: {x1.varValue}")
    else:
        print("No optimal solution found.")

optimize_problem()
