
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bowls_cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_cereal")

# Set objective function
m.setObjective(8 * apple_pies + 4 * apples + 7 * oreos + 3 * bowls_cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * apples + 18 * oreos >= 15, "c1")
m.addConstr(6 * apple_pies + 18 * apples >= 36, "c2")
m.addConstr(6 * apple_pies + 21 * bowls_cereal >= 29, "c3")
m.addConstr(6 * apple_pies + 18 * oreos >= 18, "c4")
m.addConstr(6 * apple_pies + 18 * apples + 18 * oreos >= 27, "c5")
m.addConstr(6 * apple_pies + 18 * oreos + 21 * bowls_cereal >= 27, "c6")
m.addConstr(18 * apples + 18 * oreos + 21 * bowls_cereal >= 27, "c7")
m.addConstr(6 * apple_pies + 18 * apples + 18 * oreos >= 41, "c8")
m.addConstr(6 * apple_pies + 18 * oreos + 21 * bowls_cereal >= 41, "c9")
m.addConstr(18 * apples + 18 * oreos + 21 * bowls_cereal >= 41, "c10")
m.addConstr(6 * apple_pies + 18 * apples + 18 * oreos >= 23, "c11")
m.addConstr(6 * apple_pies + 18 * oreos + 21 * bowls_cereal >= 23, "c12")
m.addConstr(18 * apples + 18 * oreos + 21 * bowls_cereal >= 23, "c13")
m.addConstr(6 * apple_pies + 18 * apples + 18 * oreos + 21 * bowls_cereal >= 23, "c14")
m.addConstr(12 * apple_pies + 15 * apples >= 18, "c15")
m.addConstr(15 * apples + 11 * oreos >= 17, "c16")
m.addConstr(12 * apple_pies + 11 * oreos >= 36, "c17")
m.addConstr(11 * oreos + 4 * bowls_cereal >= 20, "c18")
m.addConstr(12 * apple_pies + 15 * apples + 4 * bowls_cereal >= 37, "c19")
m.addConstr(12 * apple_pies + 15 * apples + 11 * oreos >= 37, "c20")
m.addConstr(12 * apple_pies + 15 * apples + 4 * bowls_cereal >= 24, "c21")
m.addConstr(12 * apple_pies + 15 * apples + 11 * oreos >= 24, "c22")
m.addConstr(12 * apple_pies + 15 * apples + 11 * oreos + 4 * bowls_cereal >= 24, "c23")
m.addConstr(-9 * oreos + 1 * bowls_cereal >= 0, "c24")
m.addConstr(6 * apple_pies + 18 * apples + 18 * oreos <= 72, "c25")
m.addConstr(6 * apple_pies + 18 * apples + 21 * bowls_cereal <= 74, "c26")
m.addConstr(18 * apples + 18 * oreos + 21 * bowls_cereal <= 50, "c27")
m.addConstr(6 * apple_pies + 18 * oreos + 21 * bowls_cereal <= 158, "c28")
m.addConstr(12 * apple_pies + 15 * apples <= 102, "c29")
m.addConstr(15 * apples + 11 * oreos <= 155, "c30")
m.addConstr(12 * apple_pies + 11 * oreos + 4 * bowls_cereal <= 116, "c31")


# Add resource constraints based on the provided dictionary (optional, if you want to include these)
resource_constraints = {
    'r0': {'upper_bound': 175, 'x0': 6, 'x1': 18, 'x2': 18, 'x3': 21},
    'r1': {'upper_bound': 157, 'x0': 12, 'x1': 15, 'x2': 11, 'x3': 4}
}

for resource, data in resource_constraints.items():
    m.addConstr(data['x0'] * apple_pies + data['x1'] * apples + data['x2'] * oreos + data['x3'] * bowls_cereal <= data['upper_bound'], resource)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
