
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(name="apple_pies", lb=0)  # apple pies
x1 = model.addVar(name="apples", lb=0)     # apples
x2 = model.addVar(name="oreos", lb=0)     # oreos
x3 = model.addVar(name="bowls_of_cereal", lb=0)  # bowls of cereal

# Objective function
model.setObjective(8 * x0 + 4 * x1 + 7 * x2 + 3 * x3, gurobi.GRB.MINIMIZE)

# Constraints
# Fat and fiber content per item
fat_content = {
    'r0': {'x0': 6, 'x1': 18, 'x2': 18, 'x3': 21},
}
fiber_content = {
    'r1': {'x0': 12, 'x1': 15, 'x2': 11, 'x3': 4},
}

# Resource upper bounds
resource_upper_bounds = {
    'r0': 175,  # grams of fat
    'r1': 157,  # grams of fiber
}

# Constraints
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 + 21 * x3 <= 175)  # Total fat
model.addConstr(12 * x0 + 15 * x1 + 11 * x2 + 4 * x3 <= 157)  # Total fiber

# Specific fat constraints
model.addConstr(18 * x1 + 18 * x2 >= 15)  # At least 15 grams of fat from apples and oreos
model.addConstr(6 * x0 + 18 * x1 >= 36)  # At least 36 grams of fat from apple pies and apples
model.addConstr(6 * x0 + 21 * x3 >= 29)  # At least 29 grams of fat from apple pies and bowls of cereal
model.addConstr(6 * x0 + 18 * x2 >= 18)  # At least 18 grams of fat from apple pies and oreos
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 >= 27)  # At least 27 grams of fat from apple pies, apples, and oreos
model.addConstr(6 * x0 + 18 * x2 + 21 * x3 >= 27)  # At least 27 grams of fat from apple pies, oreos, and bowls of cereal
model.addConstr(18 * x1 + 18 * x2 + 21 * x3 >= 27)  # At least 27 grams of fat from apples, oreos, and bowls of cereal
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 >= 41)  # At least 41 grams of fat from apple pies, apples, and oreos
model.addConstr(6 * x0 + 18 * x2 + 21 * x3 >= 41)  # At least 41 grams of fat from apple pies, oreos, and bowls of cereal
model.addConstr(18 * x1 + 18 * x2 + 21 * x3 >= 41)  # At least 41 grams of fat from apples, oreos, and bowls of cereal
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 >= 23)  # At least 23 grams of fat from apple pies and apples and oreos
model.addConstr(6 * x0 + 18 * x2 + 21 * x3 >= 23)  # At least 23 grams of fat from apple pies, oreos, and bowls of cereal
model.addConstr(18 * x1 + 18 * x2 + 21 * x3 >= 23)  # At least 23 grams of fat from apples, oreos, and bowls of cereal
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 + 21 * x3 >= 23)  # At least 23 grams of fat from all
model.addConstr(12 * x0 + 15 * x1 >= 18)  # At least 18 grams of fiber from apple pies and apples
model.addConstr(15 * x1 + 11 * x2 >= 17)  # At least 17 grams of fiber from apples and oreos
model.addConstr(12 * x0 + 11 * x2 >= 36)  # At least 36 grams of fiber from apple pies and oreos
model.addConstr(11 * x2 + 4 * x3 >= 20)  # At least 20 grams of fiber from oreos and bowls of cereal
model.addConstr(12 * x0 + 15 * x1 + 4 * x3 >= 37)  # At least 37 grams of fiber from apple pies, apples, and bowls of cereal
model.addConstr(12 * x0 + 15 * x1 + 11 * x2 >= 37)  # At least 37 grams of fiber from apple pies, apples, and oreos
model.addConstr(12 * x0 + 15 * x1 + 4 * x3 >= 24)  # At least 24 grams of fiber from apple pies, apples, and bowls of cereal
model.addConstr(12 * x0 + 15 * x1 + 11 * x2 >= 24)  # At least 24 grams of fiber from apple pies, apples, and oreos
model.addConstr(12 * x0 + 15 * x1 + 11 * x2 + 4 * x3 >= 24)  # At least 24 grams of fiber from all
model.addConstr(-9 * x2 + x3 >= 0)  # -9 times oreos plus bowls of cereal is at least zero

# Additional constraints
model.addConstr(6 * x0 + 18 * x1 + 18 * x2 <= 72)  # No more than 72 grams of fat from apple pies, apples, and oreos
model.addConstr(6 * x0 + 18 * x1 + 21 * x3 <= 74)  # No more than 74 grams of fat from apple pies, apples, and bowls of cereal
model.addConstr(18 * x1 + 18 * x2 + 21 * x3 <= 50)  # No more than 50 grams of fat from apples, oreos, and bowls of cereal
model.addConstr(6 * x0 + 18 * x2 + 21 * x3 <= 158)  # No more than 158 grams of fat from apple pies, oreos, and bowls of cereal
model.addConstr(12 * x0 + 15 * x1 <= 102)  # Up to 102 grams of fiber from apple pies and apples
model.addConstr(15 * x1 + 11 * x2 <= 155)  # No more than 155 grams of fiber from apples and oreos
model.addConstr(12 * x0 + 11 * x2 + 4 * x3 <= 116)  # No more than 116 grams of fiber from apple pies, oreos, and bowls of cereal

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("apple_pies: ", x0.varValue)
    print("apples: ", x1.varValue)
    print("oreos: ", x2.varValue)
    print("bowls_of_cereal: ", x3.varValue)
else:
    print("No optimal solution found")
