
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
    cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")

    # Set objective function
    m.setObjective(6 * fruit_salads + 2 * cantaloupes, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3 * fruit_salads + 15 * cantaloupes >= 57, "fiber_min")
    m.addConstr(11 * fruit_salads + 17 * cantaloupes >= 61, "protein_min")
    m.addConstr(1 * fruit_salads + 21 * cantaloupes >= 77, "fat_min")
    m.addConstr(-10 * fruit_salads + 2 * cantaloupes >= 0, "custom_constraint")

    m.addConstr(3 * fruit_salads + 15 * cantaloupes <= 285, "fiber_max")
    m.addConstr(11 * fruit_salads + 17 * cantaloupes <= 252, "protein_max") # Using the correct upper bound from the provided data
    m.addConstr(1 * fruit_salads + 21 * cantaloupes <= 224, "fat_max") # Using the correct upper bound from the provided data


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Number of fruit salads: {fruit_salads.x}")
        print(f"Number of cantaloupes: {cantaloupes.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
