
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")

# Objective function: minimize 6*x0 + 2*x1
m.setObjective(6*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 + 15*x1 >= 57, "at_least_57_fiber")
m.addConstr(11*x0 + 17*x1 >= 61, "at_least_61_protein")
m.addConstr(x0 + 21*x1 >= 77, "at_least_77_fat")
m.addConstr(-10*x0 + 2*x1 >= 0, "unique_constraint")
m.addConstr(3*x0 + 15*x1 <= 285, "max_fiber")
m.addConstr(11*x0 + 17*x1 <= 216, "max_protein")
m.addConstr(x0 + 21*x1 <= 211, "max_fat")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fruit salads: {x0.x}")
    print(f"Number of cantaloupes: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
