
import gurobi

def optimize_fruit_salads_and_cantaloupes():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    fruit_salads = model.addVar(name="fruit_salads", lb=0)  # Assuming lb=0, but not explicitly stated
    cantaloupes = model.addVar(name="cantaloupes", lb=0)  # Assuming lb=0, but not explicitly stated

    # Define the objective function
    model.setObjective(6 * fruit_salads + 2 * cantaloupes, gurobi.GRB.MINIMIZE)

    # Define the constraints
    # Fiber constraint: 3*fruit_salads + 15*cantaloupes >= 57
    model.addConstr(3 * fruit_salads + 15 * cantaloupes >= 57, name="fiber_constraint")

    # Protein constraint: 11*fruit_salads + 17*cantaloupes >= 61
    model.addConstr(11 * fruit_salads + 17 * cantaloupes >= 61, name="protein_constraint")

    # Fat constraint: 1*fruit_salads + 21*cantaloupes >= 77
    model.addConstr(1 * fruit_salads + 21 * cantaloupes >= 77, name="fat_constraint")

    # Mixed constraint: -10*fruit_salads + 2*cantaloupes >= 0
    model.addConstr(-10 * fruit_salads + 2 * cantaloupes >= 0, name="mixed_constraint")

    # Upper bounds
    # Fiber upper bound: 3*fruit_salads + 15*cantaloupes <= 285
    model.addConstr(3 * fruit_salads + 15 * cantaloupes <= 285, name="fiber_upper_bound")

    # Protein upper bound: 11*fruit_salads + 17*cantaloupes <= 216
    model.addConstr(11 * fruit_salads + 17 * cantaloupes <= 216, name="protein_upper_bound")

    # Fat upper bound: 1*fruit_salads + 21*cantaloupes <= 224
    model.addConstr(1 * fruit_salads + 21 * cantaloupes <= 224, name="fat_upper_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: fruit_salads = {fruit_salads.varValue}, cantaloupes = {cantaloupes.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

optimize_fruit_salads_and_cantaloupes()
