
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_food")

# Create variables
black_beans = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
cornichons = model.addVar(lb=0, vtype=GRB.INTEGER, name="cornichons")

# Set objective function
model.setObjective(2 * black_beans + 5 * cornichons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * black_beans + 13 * cornichons >= 102, "tastiness_min")
model.addConstr(25 * black_beans + 13 * cornichons >= 69, "sourness_min")
model.addConstr(4 * black_beans - 4 * cornichons >= 0, "black_beans_cornichons_ratio")
model.addConstr(20 * black_beans + 13 * cornichons <= 152, "tastiness_max")
model.addConstr(25 * black_beans + 13 * cornichons <= 240, "sourness_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Black beans: {black_beans.x}")
    print(f"  Cornichons: {cornichons.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

