
import gurobi

def optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    black_beans = m.addVar(name="black_beans", lb=0, ub=None)  # Continuous
    cornichons = m.addVar(name="cornichons", lb=0, integer=True)  # Integer

    # Objective function: Maximize 2 * black_beans + 5 * cornichons
    m.setObjective(2 * black_beans + 5 * cornichons, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(20 * black_beans + 13 * cornichons >= 102, name="tastiness_rating_min")
    m.addConstr(25 * black_beans + 13 * cornichons >= 69, name="sourness_index_min")
    m.addConstr(4 * black_beans - 4 * cornichons >= 0, name="balance_constraint")
    m.addConstr(20 * black_beans + 13 * cornichons <= 152, name="tastiness_rating_max")
    m.addConstr(25 * black_beans + 13 * cornichons <= 240, name="sourness_index_max")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Black beans: {black_beans.varValue}")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Objective: {m.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
