
import gurobipy as gp

# Create a new model
m = gp.Model("WorkOptimization")

# Create variables
bobby_hours = m.addVar(lb=0, name="bobby_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")
george_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="george_hours")

# Set objective function
m.setObjective(7.06 * bobby_hours + 2.87 * paul_hours + 5.24 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18.72 * bobby_hours + 11.73 * paul_hours >= 61, "work_quality_bobby_paul")
m.addConstr(18.72 * bobby_hours + 11.73 * paul_hours + 13.63 * george_hours >= 61, "work_quality_all")
m.addConstr(0.15 * paul_hours + 1.88 * george_hours >= 49, "quit_index_paul_george")
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours >= 25, "quit_index_bobby_paul_min")
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours + 1.88 * george_hours >= 25, "quit_index_all")
m.addConstr(5.23 * bobby_hours + 17.87 * paul_hours >= 39, "paperwork_bobby_paul")
m.addConstr(17.87 * paul_hours + 20.72 * george_hours >= 64, "paperwork_paul_george")
m.addConstr(5.23 * bobby_hours + 20.72 * george_hours >= 56, "paperwork_bobby_george")
m.addConstr(5.23 * bobby_hours + 17.87 * paul_hours + 20.72 * george_hours >= 56, "paperwork_all")
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours <= 87, "quit_index_bobby_paul_max")
m.addConstr(0.15 * paul_hours + 1.88 * george_hours <= 97, "quit_index_paul_george_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Bobby hours:', bobby_hours.x)
    print('Paul hours:', paul_hours.x)
    print('George hours:', george_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

