
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="hours_worked_by_George")

# Define the objective function
m.setObjective(7.06*x0 + 2.87*x1 + 5.24*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(18.72*x0 + 11.73*x1 >= 61, name="work_quality_rating_Bobby_Paul")
m.addConstr(18.72*x0 + 11.73*x1 + 13.63*x2 >= 61, name="work_quality_rating_all")
m.addConstr(0.15*x1 + 1.88*x2 >= 49, name="likelihood_to_quit_index_Paul_George")
m.addConstr(21.45*x0 + 0.15*x1 >= 25, name="likelihood_to_quit_index_Bobby_Paul")
m.addConstr(21.45*x0 + 0.15*x1 + 1.88*x2 >= 25, name="likelihood_to_quit_index_all")
m.addConstr(5.23*x0 + 17.87*x1 >= 39, name="paperwork_competence_rating_Bobby_Paul")
m.addConstr(17.87*x1 + 20.72*x2 >= 64, name="paperwork_competence_rating_Paul_George")
m.addConstr(5.23*x0 + 20.72*x2 >= 56, name="paperwork_competence_rating_Bobby_George")
m.addConstr(5.23*x0 + 17.87*x1 + 20.72*x2 >= 56, name="paperwork_competence_rating_all")
m.addConstr(21.45*x0 + 0.15*x1 <= 87, name="likelihood_to_quit_index_Bobby_Paul_max")
m.addConstr(0.15*x1 + 1.88*x2 <= 97, name="likelihood_to_quit_index_Paul_George_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Bobby:", x0.x)
    print("Hours worked by Paul:", x1.x)
    print("Hours worked by George:", x2.x)
else:
    print("No optimal solution found")
