
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
bobby_hours = m.addVar(name="bobby_hours", lb=0)  # Not restricted to integers
paul_hours = m.addVar(name="paul_hours", lb=0)  # Not restricted to integers
george_hours = m.addVar(name="george_hours", lb=0, integrality=gp.GRB.INTEGER)  # Must be an integer

# Define the objective function
m.setObjective(7.06 * bobby_hours + 2.87 * paul_hours + 5.24 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18.72 * bobby_hours + 11.73 * paul_hours >= 61)
m.addConstr(18.72 * bobby_hours + 11.73 * paul_hours + 13.63 * george_hours >= 61)
m.addConstr(0.15 * paul_hours + 1.88 * george_hours >= 49)
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours >= 25)
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours + 1.88 * george_hours >= 25)
m.addConstr(5.23 * bobby_hours + 17.87 * paul_hours >= 39)
m.addConstr(17.87 * paul_hours + 20.72 * george_hours >= 64)
m.addConstr(5.23 * bobby_hours + 20.72 * george_hours >= 56)
m.addConstr(5.23 * bobby_hours + 17.87 * paul_hours + 20.72 * george_hours >= 56)
m.addConstr(21.45 * bobby_hours + 0.15 * paul_hours <= 87)
m.addConstr(0.15 * paul_hours + 1.88 * george_hours <= 97)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bobby hours: {bobby_hours.varValue}")
    print(f"Paul hours: {paul_hours.varValue}")
    print(f"George hours: {george_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
