
from gurobipy import Model, GRB, quicksum

# Define the model
model = Model("Food Optimization")

# Define variables
protein_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
bagged_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
granola_bars = model.addVar(lb=0, vtype=GRB.INTEGER, name="granola_bars")
hamburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
pizza_slices = model.addVar(lb=0, vtype=GRB.INTEGER, name="pizza_slices")

# Define objective function
obj = 4*protein_bars**2 + 8*protein_bars*bagged_salads + 9*protein_bars*granola_bars + 4*protein_bars*hamburgers + 6*protein_bars*pizza_slices + 8*bagged_salads**2 + 5*bagged_salads*pizza_slices + 2*granola_bars**2 + 2*granola_bars*pizza_slices + hamburgers**2 + 5*hamburgers*pizza_slices + 9*pizza_slices**2 + 9*protein_bars + 6*bagged_salads + 8*granola_bars + 7*hamburgers

model.setObjective(obj, GRB.MAXIMIZE)

# Define constraints
model.addConstr(28*bagged_salads + 3*hamburgers >= 42, "calcium_constraint1")
model.addConstr(3*protein_bars + 28*bagged_salads + 13*pizza_slices >= 45, "calcium_constraint2")
model.addConstr(8*bagged_salads + 15*granola_bars >= 30, "cost_constraint1")
model.addConstr(6*protein_bars + 15*granola_bars >= 34, "cost_constraint2")
model.addConstr(15*granola_bars + 20*hamburgers >= 73, "cost_constraint3")
model.addConstr(20*hamburgers**2 + 6*pizza_slices**2 >= 61, "cost_constraint4")
model.addConstr(8*bagged_salads + 6*pizza_slices >= 75, "cost_constraint5")
model.addConstr(8*bagged_salads + 20*hamburgers >= 69, "cost_constraint6")
model.addConstr(15*granola_bars**2 + 6*pizza_slices**2 >= 42, "cost_constraint7")
model.addConstr(6*protein_bars + 8*bagged_salads >= 28, "cost_constraint8")
model.addConstr(6*protein_bars + 20*hamburgers >= 79, "cost_constraint9")
model.addConstr(6*protein_bars + 6*pizza_slices >= 52, "cost_constraint10")
model.addConstr(6*protein_bars + 8*bagged_salads + 20*hamburgers >= 50, "cost_constraint11")
model.addConstr(6*protein_bars + 20*hamburgers + 6*pizza_slices >= 50, "cost_constraint12")
model.addConstr(15*granola_bars**2 + 20*hamburgers**2 + 6*pizza_slices**2 >= 50, "cost_constraint13")
model.addConstr(8*bagged_salads + 15*granola_bars + 6*pizza_slices >= 50, "cost_constraint14")
model.addConstr(6*protein_bars**2 + 8*bagged_salads**2 + 20*hamburgers**2 >= 75, "cost_constraint15")
model.addConstr(6*protein_bars**2 + 20*hamburgers**2 + 6*pizza_slices**2 >= 75, "cost_constraint16")
model.addConstr(15*granola_bars + 20*hamburgers + 6*pizza_slices >= 75, "cost_constraint17")
model.addConstr(8*bagged_salads + 15*granola_bars + 6*pizza_slices >= 75, "cost_constraint18")
model.addConstr(6*protein_bars**2 + 8*bagged_salads**2 + 20*hamburgers**2 >= 71, "cost_constraint19")
model.addConstr(6*protein_bars + 20*hamburgers + 6*pizza_slices >= 71, "cost_constraint20")
model.addConstr(15*granola_bars**2 + 20*hamburgers**2 + 6*pizza_slices**2 >= 71, "cost_constraint21")
model.addConstr(8*bagged_salads + 15*granola_bars + 6*pizza_slices >= 71, "cost_constraint22")
model.addConstr(6*protein_bars + 8*bagged_salads + 20*hamburgers >= 74, "cost_constraint23")
model.addConstr(6*protein_bars + 20*hamburgers + 6*pizza_slices >= 74, "cost_constraint24")
model.addConstr(15*granola_bars**2 + 20*hamburgers**2 + 6*pizza_slices**2 >= 74, "cost_constraint25")
model.addConstr(8*bagged_salads**2 + 15*granola_bars**2 + 6*pizza_slices**2 >= 74, "cost_constraint26")


# ... (Rest of the constraints similarly)

# Solve the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

