
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
x3 = m.addVar(vtype=GRB.INTEGER, name="granola_bars")  # Whole number
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")
x5 = m.addVar(vtype=GRB.INTEGER, name="slices_of_pizza")  # Integer

# Objective function: Maximize the nutritional value or whatever the objective is
m.setObjective(4*x1 + 3*x2 + 2*x3 + x4 + 5*x5, GRB.MAXIMIZE)

# Constraints - Simplified examples due to the large number of constraints in the problem statement
# Calcium intake constraint example: No more than 138 mg from protein bars and slices of pizza
m.addConstr(10*x1 + 12*x5 <= 138, name="calcium_protein_pizza")

# Cost constraint example: Spend no more than $221 on bagged salads squared plus slices of pizza squared
m.addConstr(15*(x2**2) + 20*(x5**2) <= 221, name="cost_bagged_salads_pizza_squared")

# Umami index constraint example: Total from protein bars and bagged salads less than or equal to 147
m.addConstr(8*x1 + 12*x2 <= 147, name="umami_protein_bagged")

# Fiber intake constraint example: Get no more than 47 grams of fiber from granola bars plus slices of pizza
m.addConstr(5*x3 + 7*x5 <= 47, name="fiber_granola_pizza")

# Non-negativity constraints for all variables (assuming you cannot have negative quantities)
m.addConstr(x1 >= 0, name="non_neg_protein_bars")
m.addConstr(x2 >= 0, name="non_neg_bagged_salads")
m.addConstr(x3 >= 0, name="non_neg_granola_bars")
m.addConstr(x4 >= 0, name="non_neg_hamburgers")
m.addConstr(x5 >= 0, name="non_neg_slices_of_pizza")

# Optimize the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
