
import gurobi as gp

model = gp.Model("optimization_problem")

x0 = model.addVar(name="protein_bars", lb=0, ub=None)  
x1 = model.addVar(name="bagged_salads", lb=0, ub=None)
x2 = model.addVar(name="granola_bars", lb=0, ub=None, integrality=gp.GRB.INTEGER)
x3 = model.addVar(name="hamburgers", lb=0, ub=None)
x4 = model.addVar(name="slices_of_pizza", lb=0, ub=None, integrality=gp.GRB.INTEGER)

model.setObjective(4*x0**2 + 8*x0*x1 + 9*x0*x2 + 4*x0*x3 + 6*x0*x4 + 
                   8*x1**2 + 5*x1*x4 + 2*x2**2 + 2*x2*x4 + x3**2 + 
                   5*x3*x4 + 9*x4**2 + 9*x0 + 6*x1 + 8*x2 + 7*x3, gp.GRB.MAXIMIZE)

# Calcium constraints
model.addConstr(3*x0 + 28*x1 + 14*x2 + 3*x3 + 13*x4 <= 267, name="calcium_total")
model.addConstr(28*x1 + 3*x3 >= 42, name="calcium_bagged_salads_hamburgers")
model.addConstr(3*x0 + 28*x1 + 13*x4 >= 45, name="calcium_protein_bars_bagged_salads_pizza")

model.addConstr(6*x0 + 8*x1 + 15*x2 + 20*x3 + 6*x4 <= 408, name="cost_total")
model.addConstr(8*x1 + 15*x2 >= 30, name="cost_bagged_salads_granola_bars")
model.addConstr(6*x0 + 15*x2 >= 34, name="cost_protein_bars_granola_bars")
model.addConstr(20*x3 + 15*x2 >= 73, name="cost_hamburgers_granola_bars")
model.addConstr(6*x0 + 20*x3 + 6*x4 >= 61, name="cost_hamburgers_pizza")
model.addConstr(8*x1 + 6*x4 >= 75, name="cost_bagged_salads_pizza")
model.addConstr(8*x1 + 20*x3 >= 69, name="cost_bagged_salads_hamburgers")
model.addConstr(15*x2 + 20*x3 + 6*x4 >= 42, name="cost_granola_bars_hamburgers_pizza")

model.addConstr(14*x0 + 28*x1 + 22*x2 + 16*x3 + 23*x4 <= 152, name="umami_total")

model.addConstr(27*x0 + 29*x1 + 28*x2 + 22*x3 + 5*x4 <= 216, name="fiber_total")

model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Protein bars: ", x0.varValue)
    print("Bagged salads: ", x1.varValue)
    print("Granola bars: ", x2.varValue)
    print("Hamburgers: ", x3.varValue)
    print("Slices of pizza: ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
